/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.sqlite.Database;
import org.sqlite.Statement;
import org.sqlite.jdbc.JdbcConnection;
import org.sqlite.jdbc.JdbcParameterMetaData;
import org.sqlite.jdbc.JdbcResultSet;
import org.sqlite.jdbc.JdbcResultSetMetaData;
import org.sqlite.jdbc.JdbcStatement;
import org.sqlite.types.SQLite3StmtPtrPtr;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    private final String sql;
    private SQLite3StmtPtrPtr pStmt = new SQLite3StmtPtrPtr();
    private Statement stmt;

    public JdbcPreparedStatement(Database db, JdbcConnection conn, String sql) throws SQLException {
        super(db, conn);
        this.stmt = db.prepare(sql, this.pStmt);
        this.sql = sql;
        this.stmt.reset();
    }

    public ResultSet executeQuery() throws SQLException {
        this.validateStatementOpen();
        if (!this.stmt.producedResultSet()) {
            throw new SQLException("No ResultSet was produced.");
        }
        this.rs = new JdbcResultSet(this, this.stmt);
        this.cntUpdate = -1;
        return this.rs;
    }

    public int executeUpdate() throws SQLException {
        this.validateStatementOpen();
        if (this.stmt.producedResultSet()) {
            throw new SQLException("ResultSet was produced.");
        }
        this.stmt.execute();
        this.cntUpdate = this.db.changes();
        this.rs = null;
        this.stmt.reset();
        return this.cntUpdate;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindNull(parameterIndex);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x ? 1 : 0);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindDouble(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.validateStatementOpen();
        this.stmt.bindText(parameterIndex, x.toString());
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, x);
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindBytes(parameterIndex, x);
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, new SimpleDateFormat("yyyy-MM-dd").format(x));
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, new SimpleDateFormat("HH:mm:ss").format(x));
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.validateStatementOpen();
        if (x != null) {
            this.stmt.bindText(parameterIndex, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(x));
        } else {
            this.stmt.bindNull(parameterIndex);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void clearParameters() throws SQLException {
        this.validateStatementOpen();
        this.stmt.clearBinding();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean execute() throws SQLException {
        this.validateStatementOpen();
        return this.executeQuery() != null;
    }

    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new JdbcResultSetMetaData(this.stmt);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTime(x);
        this.setDate(parameterIndex, new Date(calendar.getTime().getTime()));
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTime(x);
        this.setTime(parameterIndex, new Time(calendar.getTime().getTime()));
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        Calendar calendar = (Calendar)cal.clone();
        calendar.setTime(x);
        this.setTimestamp(parameterIndex, new Timestamp(calendar.getTime().getTime()));
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new JdbcParameterMetaData(this.stmt);
    }

    public boolean isClosed() throws SQLException {
        return this.pStmt == null || super.isClosed();
    }

    public void close() throws SQLException {
        if (this.pStmt != null) {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.pStmt.delete();
            this.pStmt = null;
        }
        super.close();
    }

    public void detach(ResultSet drs) throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null && drs.getStatement() == this) {
            this.rs = null;
            this.stmt.clearBinding();
            this.stmt = this.db.prepare(this.sql, this.pStmt);
            this.stmt.reset();
        }
    }

    public void detachAndClose(ResultSet drs) throws SQLException {
        this.validateStatementOpen();
        if (this.rs != null && drs.getStatement() == this) {
            this.rs = null;
            this.stmt = null;
            this.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public int findParameter(String parameterName) throws SQLException {
        this.validateStatementOpen();
        int parameterIndex = this.stmt.getParameterIndex(parameterName);
        if (parameterIndex == 0) {
            throw new SQLException("Parameter name is not found.");
        }
        return parameterIndex;
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameter(parameterName), sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameter(parameterName), x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameter(parameterName), x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameter(parameterName), x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameter(parameterName), x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameter(parameterName), x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameter(parameterName), x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameter(parameterName), x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameter(parameterName), x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameter(parameterName), x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameter(parameterName), x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameter(parameterName), x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameter(parameterName), x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParameter(parameterName), x);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameter(parameterName), x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameter(parameterName), x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameter(parameterName), x, cal);
    }

    public String findParameterName(int parameterIndex) throws SQLException {
        this.validateStatementOpen();
        return this.stmt.getParameterName(parameterIndex);
    }
}

