/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import org.sqlite.Database;
import org.sqlite.Driver;
import org.sqlite.jdbc.JdbcPreparedStatement;
import org.sqlite.jdbc.JdbcStatement;
import org.sqlite.swig.SQLite3;
import org.sqlite.swig.SQLite3Constants;

public class JdbcDatabaseMetaData
implements DatabaseMetaData {
    private final Database db;
    private final Connection conn;

    JdbcDatabaseMetaData(Database db, Connection conn) {
        this.db = db;
        this.conn = conn;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.db.getURL();
    }

    public String getUserName() throws SQLException {
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "SQLite";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return SQLite3.getSqlite3_version();
    }

    public String getDriverName() throws SQLException {
        return Driver.getDriverName();
    }

    public String getDriverVersion() throws SQLException {
        return Driver.getDriverVersion();
    }

    public int getDriverMajorVersion() {
        return Driver.getDriverMajorVersion();
    }

    public int getDriverMinorVersion() {
        return Driver.getDriverMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "";
    }

    public String getNumericFunctions() throws SQLException {
        return "";
    }

    public String getStringFunctions() throws SQLException {
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "date,time,datetime,julianday,strftime";
    }

    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        return null;
    }

    public String getCatalogTerm() throws SQLException {
        return null;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql = "SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS RESERVED_4, NULL AS RESERVED_5, NULL AS RESERVED_6, NULL AS REMARKS, NULL AS SPECIFIC_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS RESERVED_4, NULL AS RESERVED_5, NULL AS RESERVED_6, NULL AS REMARKS, NULL AS SPECIFIC_NAME LIMIT 0");
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String sql = "SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS COLUMN_NAME, NULL AS COLUMN_TYPE, NULL AS DATA_TYPE, NULL AS TYPE_NAME, NULL AS PRECISION, NULL AS LENGTH, NULL AS SCALE, NULL AS RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SPECIFIC_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, NULL AS PROCEDURE_NAME, NULL AS COLUMN_NAME, NULL AS COLUMN_TYPE, NULL AS DATA_TYPE, NULL AS TYPE_NAME, NULL AS PRECISION, NULL AS LENGTH, NULL AS SCALE, NULL AS RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS COLUMN_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SPECIFIC_NAME LIMIT 0");
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String sqlTemplate = "SELECT  NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, name AS TABLE_NAME, type AS TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, sql AS SQL FROM sqlite_master WHERE (?1 IS NULL OR name LIKE ?1) AND (type IN ({0})) ORDER BY TABLE_TYPE, TABLE_NAME";
        if (types == null || types.length == 0) {
            types = new String[]{"table", "view"};
        }
        int typesSize = types.length;
        StringBuilder paramTypes = new StringBuilder();
        for (int i = 0; i < typesSize; ++i) {
            paramTypes.append("?").append(i + 2).append(",");
        }
        int last = paramTypes.length();
        paramTypes.delete(last - 1, last);
        Object[] arguments = new Object[]{paramTypes.toString()};
        String sql = new MessageFormat("SELECT  NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, name AS TABLE_NAME, type AS TABLE_TYPE, NULL AS REMARKS, NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SELF_REFERENCING_COL_NAME, NULL AS REF_GENERATION, sql AS SQL FROM sqlite_master WHERE (?1 IS NULL OR name LIKE ?1) AND (type IN ({0})) ORDER BY TABLE_TYPE, TABLE_NAME").format(arguments);
        PreparedStatement pstmt = this.conn.prepareStatement(sql);
        int parameterIndex = 1;
        pstmt.setString(parameterIndex++, tableNamePattern);
        for (String type : types) {
            pstmt.setString(parameterIndex++, type);
        }
        ResultSet rs = pstmt.executeQuery();
        ((JdbcPreparedStatement)pstmt).detachAndClose(rs);
        return rs;
    }

    public ResultSet getSchemas() throws SQLException {
        String sql = "SELECT NULL AS TABLE_SCHEM, NULL AS TABLE_CATALOG LIMIT 0";
        return this.produceDetachedResultSet("SELECT NULL AS TABLE_SCHEM, NULL AS TABLE_CATALOG LIMIT 0");
    }

    public ResultSet getCatalogs() throws SQLException {
        String sql = "SELECT NULL AS TABLE_CAT LIMIT 0";
        return this.produceDetachedResultSet("SELECT NULL AS TABLE_CAT LIMIT 0");
    }

    public ResultSet getTableTypes() throws SQLException {
        String sql = "SELECT 'TABLE' AS TABLE_TYPE UNION ALL SELECT 'VIEW' AS TABLE_TYPE";
        return this.produceDetachedResultSet("SELECT 'TABLE' AS TABLE_TYPE UNION ALL SELECT 'VIEW' AS TABLE_TYPE");
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS COLUMN_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS COLUMN_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0");
    }

    public ResultSet getTablePrivileges(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS GRANTOR, NULL AS GRANTEE, NULL AS PRIVILEGE, NULL AS IS_GRANTABLE LIMIT 0");
    }

    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM, NULL AS PKTABLE_NAME, NULL AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM, NULL AS FKTABLE_NAME, NULL AS FKCOLUMN_NAME, NULL AS KEY_SEQ, NULL AS UPDATE_RULE, NULL AS DELETE_RULE, NULL AS FK_NAME, NULL AS PK_NAME, NULL AS DEFERRABILITY LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM, NULL AS PKTABLE_NAME, NULL AS PKCOLUMN_NAME, NULL AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM, NULL AS FKTABLE_NAME, NULL AS FKCOLUMN_NAME, NULL AS KEY_SEQ, NULL AS UPDATE_RULE, NULL AS DELETE_RULE, NULL AS FK_NAME, NULL AS PK_NAME, NULL AS DEFERRABILITY LIMIT 0");
    }

    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public ResultSet getTypeInfo() throws SQLException {
        String sql = "SELECT   TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, NULL AS CREATE_PARAMS, 1 AS NULLABLE, CASE_SENSITIVE, 3 AS SEARCHABLE, UNSIGNED_ATTRIBUTE, 0 AS FIXED_PREC_SCALE, AUTO_INCREMENT, TYPE_NAME AS LOCAL_TYPE_NAME, 0 AS MINIMUM_SCALE, 0 AS MAXIMUM_SCALE, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NUM_PREC_RADIX FROM (SELECT  'NULL' AS TYPE_NAME, 0 AS DATA_TYPE, NULL AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX UNION ALL SELECT  'INTEGER' AS TYPE_NAME, 4 AS DATA_TYPE, 10 AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 1 AS UNSIGNED_ATTRIBUTE, 1 AS AUTO_INCREMENT, 10 AS NUM_PREC_RADIX UNION ALL SELECT  'REAL' AS TYPE_NAME, 7 AS DATA_TYPE, 16 AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 1 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, 10 AS NUM_PREC_RADIX UNION ALL SELECT  'TEXT' AS TYPE_NAME, 12 AS DATA_TYPE, 2147483647 AS PRECISION, '''' AS LITERAL_PREFIX, '''' AS LITERAL_SUFFIX, 1 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX UNION ALL SELECT  'BLOB' AS TYPE_NAME, 2004 AS DATA_TYPE, 2147483647 AS PRECISION, 'X''' AS LITERAL_PREFIX, '''' AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX) AS TYPE_INFO ORDER BY TYPE_NAME";
        return this.produceDetachedResultSet("SELECT   TYPE_NAME, DATA_TYPE, PRECISION, LITERAL_PREFIX, LITERAL_SUFFIX, NULL AS CREATE_PARAMS, 1 AS NULLABLE, CASE_SENSITIVE, 3 AS SEARCHABLE, UNSIGNED_ATTRIBUTE, 0 AS FIXED_PREC_SCALE, AUTO_INCREMENT, TYPE_NAME AS LOCAL_TYPE_NAME, 0 AS MINIMUM_SCALE, 0 AS MAXIMUM_SCALE, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NUM_PREC_RADIX FROM (SELECT  'NULL' AS TYPE_NAME, 0 AS DATA_TYPE, NULL AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX UNION ALL SELECT  'INTEGER' AS TYPE_NAME, 4 AS DATA_TYPE, 10 AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 1 AS UNSIGNED_ATTRIBUTE, 1 AS AUTO_INCREMENT, 10 AS NUM_PREC_RADIX UNION ALL SELECT  'REAL' AS TYPE_NAME, 7 AS DATA_TYPE, 16 AS PRECISION, NULL AS LITERAL_PREFIX, NULL AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 1 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, 10 AS NUM_PREC_RADIX UNION ALL SELECT  'TEXT' AS TYPE_NAME, 12 AS DATA_TYPE, 2147483647 AS PRECISION, '''' AS LITERAL_PREFIX, '''' AS LITERAL_SUFFIX, 1 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX UNION ALL SELECT  'BLOB' AS TYPE_NAME, 2004 AS DATA_TYPE, 2147483647 AS PRECISION, 'X''' AS LITERAL_PREFIX, '''' AS LITERAL_SUFFIX, 0 AS CASE_SENSITIVE, 0 AS UNSIGNED_ATTRIBUTE, 0 AS AUTO_INCREMENT, NULL AS NUM_PREC_RADIX) AS TYPE_INFO ORDER BY TYPE_NAME");
    }

    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 1007;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int arg0) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int arg0) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int arg0) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String sql = "SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, NULL AS DATA_TYPE, NULL AS REMARKS, NULL AS BASE_TYPE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS CLASS_NAME, NULL AS DATA_TYPE, NULL AS REMARKS, NULL AS BASE_TYPE LIMIT 0");
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return true;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return true;
    }

    public ResultSet getSuperTypes(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SUPERTYPE_CAT, NULL AS SUPERTYPE_SCHEM, NULL AS SUPERTYPE_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS TYPE_NAME, NULL AS SUPERTYPE_CAT, NULL AS SUPERTYPE_SCHEM, NULL AS SUPERTYPE_NAME LIMIT 0");
    }

    public ResultSet getSuperTables(String arg0, String arg1, String arg2) throws SQLException {
        String sql = "SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS SUPERTABLE_NAME LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, NULL AS TABLE_NAME, NULL AS SUPERTABLE_NAME LIMIT 0");
    }

    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        String sql = "SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS ATTR_NAME, NULL AS DATA_TYPE, NULL AS ATTR_TYPE_NAME, NULL AS ATTR_SIZE, NULL AS DECIMAL_DIGITS, NULL AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS ATTR_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE LIMIT 0";
        return this.produceDetachedResultSet("SELECT   NULL AS TYPE_CAT, NULL AS TYPE_SCHEM, NULL AS ATTR_NAME, NULL AS DATA_TYPE, NULL AS ATTR_TYPE_NAME, NULL AS ATTR_SIZE, NULL AS DECIMAL_DIGITS, NULL AS NUM_PREC_RADIX, NULL AS NULLABLE, NULL AS REMARKS, NULL AS ATTR_DEF, NULL AS SQL_DATA_TYPE, NULL AS SQL_DATETIME_SUB, NULL AS CHAR_OCTET_LENGTH, NULL AS ORDINAL_POSITION, NULL AS IS_NULLABLE, NULL AS SCOPE_CATALOG, NULL AS SCOPE_SCHEMA, NULL AS SCOPE_TABLE, NULL AS SOURCE_DATA_TYPE LIMIT 0");
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return SQLite3Constants.SQLITE_VERSION_NUMBER / 1000000;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return SQLite3Constants.SQLITE_VERSION_NUMBER % 1000000 / 1000;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private ResultSet produceDetachedResultSet(String sql) throws SQLException {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ((JdbcStatement)stmt).detach(rs);
        stmt.close();
        return rs;
    }
}

