/*
*** SQLITE3[U`֐R[obN
*/
class osqlite3func
{
protected:

	/*
	*** R[obN^(A}l[W)
	*/
	typedef void (WINAPI *CallFuncType)(sqlite3_context*,int,sqlite3_value**);
	typedef void (WINAPI *CallStepType)(sqlite3_context*,int,sqlite3_value**);
	typedef void (WINAPI *CallFinalType)(sqlite3_context*);

	/*
	*** R[obN|C
	*/
	CallFuncType CallFunc ;
	CallStepType CallStep ;
	CallFinalType CallFinal ;

#ifdef _WIN32_WCE

	/*
	*** CLRCxg
	*/
	HANDLE m_clrevent;
	/*
	*** ێ
	*/
	int m_kind;
	sqlite3_context* m_context;
	int m_argc;
	sqlite3_value** m_args;

	HANDLE m_paramevent;
#endif

public:

	/*
	*** R[obN|CgZbg
	*/
	void SetCallPoint( CallFuncType callfunc, CallStepType callstep, CallFinalType callfinal )
	{
		CallFunc = callfunc;
		CallStep = callstep;
		CallFinal = callfinal;
	}

	/*
	*** R[obN
	*/
	void CallFunc_Call( sqlite3_context* a,int b ,sqlite3_value** c )
	{
#ifdef _WIN32_WCE
		m_kind = 1;
		m_context = a;
		m_argc = b;
		m_args = c;

		//R[obNCxg쐬
		m_paramevent = CreateEvent(NULL, true, false, NULL);

		//CLRCxgVOi
		SetEvent( m_clrevent );

		//CLRŏ܂őҋ@
		DWORD dwResult = WaitForSingleObject( m_paramevent, INFINITE );
#else
		CallFunc( a, b, c);
#endif
	}

	/*
	*** R[obN
	*/
	void CallStep_Call( sqlite3_context* a,int b ,sqlite3_value** c )
	{
#ifdef _WIN32_WCE
		m_kind = 2;
		m_context = a;
		m_argc = b;
		m_args = c;

		//R[obNCxg쐬
		m_paramevent = CreateEvent(NULL, true, false, NULL);

		//CLRCxgVOi
		SetEvent( m_clrevent );

		//CLRŏ܂őҋ@
		DWORD dwResult = WaitForSingleObject( m_paramevent, INFINITE );
#else
		CallStep( a, b, c);
#endif
	}

	/*
	*** R[obN
	*/
	void CallFinal_Call( sqlite3_context* a )
	{
#ifdef _WIN32_WCE
		m_kind = 3;
		m_context = a;

		//R[obNCxg쐬
		m_paramevent = CreateEvent(NULL, true, false, NULL);

		//CLRCxgVOi
		SetEvent( m_clrevent );

		//CLRŏ܂őҋ@
		DWORD dwResult = WaitForSingleObject( m_paramevent, INFINITE );
#else
		CallFinal( a );
#endif
	}

#ifdef _WIN32_WCE

	/*
	*** R[obN|CgZbg
	*/
	void SetCLREvent( HANDLE clrevent )
	{
		m_clrevent = clrevent;
	}

	/*
	*** R[obN擾
	*/
	int GetCallBackParam( int* pargc )
	{
		*pargc = m_argc;

		return m_kind;
	}

	/*
	*** ^
	*/
	int GetParamType( int iNo )
	{
		return sqlite3_value_type( m_args[ iNo ] );
	}

	/*
	*** ^擾
	*/
	int GetParamInt( int iNo )
	{
		return sqlite3_value_int( m_args[ iNo ] );
	}

	/*
	*** _^擾
	*/
	double GetParamDouble( int iNo )
	{
		return sqlite3_value_double( m_args[ iNo ] );
	}

	/*
	*** ^擾
	*/
	const wchar_t* GetParamText( int iNo )
	{
		return (const wchar_t*)sqlite3_value_text16( m_args[ iNo ] );
	}

	/*
	*** oCi^擾
	*/
	const void* GetParamBlob( int iNo, int* piLen )
	{
		*piLen = sqlite3_value_bytes( m_args[ iNo ] );

		return sqlite3_value_blob( m_args[ iNo ] );
	}

	/*
	*** ^ʃZbg
	*/
	void SetResultInt( int val )
	{
		sqlite3_result_int( m_context, val );
	}

	/*
	*** _^ʃZbg
	*/
	void SetResultDouble( double val )
	{
		sqlite3_result_double( m_context, val );
	}

	/*
	*** ^ʃZbg
	*/
	void SetResultText( wchar_t* val, int iLen )
	{
		sqlite3_result_text16( m_context, val, iLen, SQLITE_TRANSIENT );
	}

	/*
	*** oCi^ʃZbg
	*/
	void SetResultBlob( void* val, int iLen )
	{
		sqlite3_result_blob( m_context, val, iLen, SQLITE_TRANSIENT );
	}

	/*
	*** G[Zbg
	*/
	void SetResultError( wchar_t* val, int iLen )
	{
		sqlite3_result_error16( m_context, val, iLen );
	}

	/*
	*** ToobigG[Zbg
	*/
	void SetResultErrorToobig()
	{
		sqlite3_result_error_toobig( m_context );
	}

	/*
	*** NomemG[Zbg
	*/
	void SetResultErrorNomem()
	{
		sqlite3_result_error_nomem( m_context );
	}

	/*
	*** G[R[hZbg
	*/
	void SetResultErrorCode( int iVal )
	{
		sqlite3_result_error_code( m_context, iVal );
	}

	/*
	*** R[obN
	*/
	void FinishCallBackParam()
	{
		m_kind = 0;

		HANDLE paramevent = m_paramevent;
		m_paramevent = NULL;

		SetEvent( paramevent );
		CloseHandle( paramevent );
	}
#endif
};
