#include "stdafx.h"


/*
*** RXgN^
*** db : f[^x[XCX^X
*/
osqlite3_stmt::osqlite3_stmt( osqlite3* db )
{
	m_db = db;
	m_statement = NULL;
}

/*
*** fXgN^
*/
osqlite3_stmt::~osqlite3_stmt()
{
	finalize();
}

/*
*** Xe[ggj
*/
void osqlite3_stmt::finalize()
{
	if( m_statement != NULL )
	{
		sqlite3_finalize(m_statement);//I

		m_statement = NULL;
	}
}

/*
*** SQLs
*/
bool osqlite3_stmt::execute( wchar_t* sql )
{
	if( prepare( sql ) == false )
		return false;

	if( step() != SQLITE_DONE )
		return false;

	return true;
}

/*
*** Xe[gg\
*/
bool osqlite3_stmt::prepare( wchar_t* sql )
{
	finalize();

	m_db->m_lasterr = sqlite3_prepare16( m_db->m_db, (const char*)sql, (int)wcslen(sql)*sizeof(wchar_t), &m_statement, NULL);//R[h̃RpC
	if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	//Xe[gg̏
	sqlite3_reset(m_statement);

	return true;
}

/*
*** f[^ʃJEg
*/
int osqlite3_stmt::data_count()
{
	m_db->m_lasterr = sqlite3_data_count(m_statement);
	return m_db->m_lasterr;
}

/*
*** f[^ʃJJEg
*/
int osqlite3_stmt::column_count()
{
	m_db->m_lasterr = sqlite3_column_count(m_statement);
	return m_db->m_lasterr;
}

/*
*** \s
*** J[\s
*/
int osqlite3_stmt::step()
{
	m_db->m_lasterr = sqlite3_step(m_statement);
	return m_db->m_lasterr;
}

/*
*** J^Cv擾
*** ߒl:<sqlite3.h>Q
*/
int osqlite3_stmt::getType( int icol )
{
	return sqlite3_column_type( m_statement, icol );
}


/*
*** ^l擾
*/
int osqlite3_stmt::getInt( int icol )
{
	return sqlite3_column_int( m_statement, icol );
}

/*
*** ^l擾
*/
sqlite3_int64 osqlite3_stmt::getInt64( int icol )
{
	return sqlite3_column_int( m_statement, icol );
}

/*
*** _l擾
*/
double osqlite3_stmt::getDouble( int icol )
{
	return sqlite3_column_double( m_statement, icol );
}

/*
*** l擾
*/
const wchar_t* osqlite3_stmt::getText( int icol )
{
	return (const wchar_t*)sqlite3_column_text16( m_statement, icol );
}

/*
*** BLOBl擾
*/
const void* osqlite3_stmt::getBlob( int icol, int& valsize )
{
	const void* val = sqlite3_column_blob( m_statement, icol );
	valsize = sqlite3_column_bytes( m_statement, icol );

	return val;
}

/*
*** J擾
*/
const wchar_t* osqlite3_stmt::getColumnName( int icol )
{
	return (const wchar_t*)sqlite3_column_name16( m_statement, icol );
}

/*
*** J̃e[u擾
*/
const wchar_t* osqlite3_stmt::getColumnTableName( int icol )
{
	return (const wchar_t*)sqlite3_column_table_name16( m_statement, icol );
}
/*
*** J̌̎擾
*/
const wchar_t* osqlite3_stmt::getColumnOriginalName( int icol )
{
	return (const wchar_t*)sqlite3_column_origin_name16( m_statement, icol );
}

/*
*** J̐錾擾
*/
const wchar_t* osqlite3_stmt::getColumnDecltype( int icol )
{
	return (const wchar_t*)sqlite3_column_decltype16( m_statement, icol );
}

/*
*** oChϐZbg
*/
bool osqlite3_stmt::reset()
{
	m_db->m_lasterr = sqlite3_reset( m_statement );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** ^UoCh
*** SQLite3ŁAT|[g^Ȃ̂ŁAlƂĊi[B
*/
bool osqlite3_stmt::bindBool( int icol, bool val )
{
	m_db->m_lasterr = sqlite3_bind_int( m_statement, icol, (int)val );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** oCh
*/
bool osqlite3_stmt::bindInt( int icol, int val )
{
	m_db->m_lasterr = sqlite3_bind_int( m_statement, icol, val );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** oCh
*/
bool osqlite3_stmt::bindInt64( int icol, sqlite3_int64 val )
{
	m_db->m_lasterr = sqlite3_bind_int64( m_statement, icol, val );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** _oCh
*/
bool osqlite3_stmt::bindDouble( int icol, double val )
{
	m_db->m_lasterr = sqlite3_bind_double( m_statement, icol, val );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** oCh
*/
bool osqlite3_stmt::bindDecimal( int icol, long double val )
{
	m_db->m_lasterr = sqlite3_bind_double( m_statement, icol, val );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** oCh
*/
bool osqlite3_stmt::bindText( int icol, wchar_t* val )
{
	m_db->m_lasterr = sqlite3_bind_text16( m_statement, icol, (const void*)val, (int)wcslen(val)*sizeof(wchar_t), SQLITE_TRANSIENT );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** NULLoCh
*/
bool osqlite3_stmt::bindNull( int icol )
{
	m_db->m_lasterr = sqlite3_bind_null( m_statement, icol );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}

/*
*** BloboCh
*/
bool osqlite3_stmt::bindBlob( int icol, void* val, int valsize )
{
	m_db->m_lasterr = sqlite3_bind_blob( m_statement, icol, (const void*)val, valsize, SQLITE_TRANSIENT  );
		if(SQLITE_OK != m_db->m_lasterr )
	{
		//G[
		return false;
	}

	return true;
}
