using System;
using System.Runtime.InteropServices;

namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// ϊ }l[WA}l[W
	/// </summary>
	public class StringToC : IDisposable
	{
		/// <summary>
		/// 
		/// </summary>
		protected IntPtr m_cstr = IntPtr.Zero;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="str"></param>
		public StringToC( String str )
		{
			m_cstr = Marshal.StringToHGlobalAuto(str);
		}

		/// <summary>
		/// C|C^
		/// </summary>
		unsafe public void* CStr
		{
			get
			{
				return m_cstr.ToPointer();
			}
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		~StringToC()
		{
			Dispose();
		}

		/// <summary>
		/// j
		/// </summary>
		public void Dispose()
		{
			if( m_cstr != IntPtr.Zero )
			{
				Marshal.FreeHGlobal(m_cstr);
				m_cstr = IntPtr.Zero;
			}
		}
	}
}
