using System;
using System.Data;
using System.ComponentModel;

using SQLiteCSLib.Inner;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLitegUNV
	/// </summary>
	public class SQLiteTransaction : Component, IDbTransaction, IDisposable
	{
		/// <summary>
		/// SQLiteڑ
		/// </summary>
		protected SQLiteConnection m_connect = null;

		/// <summary>
		/// SQLiteڑvpeB
		/// </summary>
		public SQLiteConnection Connect
		{
			get
			{
				return m_connect;
			}
			set
			{
				m_connect = value;
			}
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteTransaction()
		{
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="connect">SQLiteڑ</param>
		public SQLiteTransaction( SQLiteConnection connect )
		{
			m_connect = connect;

			using( OSQLiteStmtWrap stmt = m_connect.OSQLiteDB.CreateStmt() )
			{
				stmt.Execute("BEGIN");
			}
		}

		/// <summary>
		/// [obN
		/// </summary>
		public void Rollback()
		{
			using( OSQLiteStmtWrap stmt = m_connect.OSQLiteDB.CreateStmt() )
			{
				stmt.Execute("ROLLBACK");
			}
		}

		/// <summary>
		/// R~bg
		/// </summary>
		public void Commit()
		{
			using( OSQLiteStmtWrap stmt = m_connect.OSQLiteDB.CreateStmt() )
			{
				stmt.Execute("COMMIT");
			}
		}

		/// <summary>
		/// ڑvpeB
		/// </summary>
		public IDbConnection Connection
		{
			get
			{
				return m_connect;
			}
		}

		/// <summary>
		/// gUNV
		/// T|[g
		/// </summary>
		public IsolationLevel IsolationLevel
		{
			get
			{
				return new IsolationLevel();
			}
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		new public void Dispose()
		{
		}
	}
}
