#pragma once

#include "sqlite3.h"
#include "osqlite3func.h"
#include "osqlite3collation.h"

#include<vector>

/*
*** SQLITE3 bp[
*/
class osqlite3
{
	friend class osqlite3_stmt;
protected:

	/*
	*** f[^x[XCX^X
	*/
	sqlite3* m_db;

	/*
	*** ŏIG[R[h
	*/
	int m_lasterr;

	/*
	*** [U`֐R[obNXg
	*/
	std::vector<osqlite3func*> m_userfunclist;

	/*
	*** [U`ƍ֐R[obNXg
	*/
	std::vector<osqlite3collation*> m_usercollationlist;

	/*
	*** o[W
	*/
	std::string m_version;

public:

	/*
	*** RXgN^
	*/
	osqlite3();

	/*
	*** fXgN^
	*/
	~osqlite3();

	/*
	*** o[W
	*/
	const char* libversion();

	/*
	*** ڑI[v
	*** filename : t@C(f[^x[XpX)
	*/
	bool open( wchar_t* filename );

	/*
	*** ؒf
	*/
	void close();

	/*
	*** ŏIG[R[h擾
	*/
	int getLastErr() { return m_lasterr; }

	/*
	*** ŏIG[bZ[W擾
	*/
	const wchar_t* getLastErrMsg();

	/*
	*** f
	*/
	void interrupt();

	/*
	*** XVes
	*/
	int changes();

	/*
	*** ŏIǉROWID
	*/
	sqlite3_int64 last_insert_rowid();

#ifdef _WIN32_WCE
	/*
	*** [U`֐쐬
	*/
	int createfunction( wchar_t* funcname, int iarg, int eTextRep, 
		HANDLE clrevent, osqlite3func** instancepoint
		, bool xFunc, bool xStep, bool xFinal );
#else
	/*
	*** [U`֐쐬
	*/
	int createfunction( wchar_t* funcname, int iarg, int eTextRep, 
		void (WINAPI *xFunc)(sqlite3_context*,int,sqlite3_value**),
		void (WINAPI *xStep)(sqlite3_context*,int,sqlite3_value**),
		void (WINAPI *xFinal)(sqlite3_context*) );
#endif

#ifdef _WIN32_WCE
	/*
	*** [U`ƍ֐쐬
	*/
	int createcollation( wchar_t* funcname, int eTextRep, 
		HANDLE clrevent,
		osqlite3collation** instancepoint );
#else
	/*
	*** [U`ƍ֐쐬
	*/
	int createcollation( wchar_t* funcname, int eTextRep, 
		int(WINAPI *xCompare)(void*,int,const void*,int,const void*) );
#endif

protected:
	/*
	*** XJ[֐ꎞR[obN
	*/
	static void CallFunc( sqlite3_context* a,int b ,sqlite3_value** c );

	/*
	*** W֐XebvꎞR[obN
	*/
	static void CallStep( sqlite3_context* a,int b ,sqlite3_value** c );

	/*
	*** W֐ŏIꎞR[obN
	*/
	static void CallFinal( sqlite3_context* a );

	/*
	*** [U`ƍ֐ꎞR[obN
	*/
	static int CallCompare(void* a,int b,const void* c,int d,const void* e);
};
