#include "stdafx.h"


/*
*** RXgN^
*/
osqlite3::osqlite3()
{
	m_db = NULL;
	m_lasterr = 0;
}

/*
*** fXgN^
*/
osqlite3::~osqlite3()
{
	close();

	//[U֐R[obNXgj
	{
		std::vector<osqlite3func*>::iterator it ;
		for( it = m_userfunclist.begin(); it != m_userfunclist.end(); it++ )
		{
			delete *it;
		}
	}

	{
		//[U֐R[obNXgj
		std::vector<osqlite3collation*>::iterator it ;
		for( it = m_usercollationlist.begin(); it != m_usercollationlist.end(); it++ )
		{
			delete *it;
		}
	}
}

/*
*** o[W
*/
const char* osqlite3::libversion()
{
	if( m_version.length() == 0 )
		m_version = sqlite3_libversion();

	return m_version.c_str();
}

/*
*** I[v
*/
bool osqlite3::open( wchar_t* filename )
{
	if( m_db != NULL )
	{
		sqlite3_close(m_db);
		m_db = NULL;
	}

	// open database
	m_lasterr = sqlite3_open16( (const char*)filename, &m_db );
	if (m_lasterr != SQLITE_OK)
	{
		m_db = NULL;
		return false;
	}

	return true;
}

/*
*** N[Y
*/
void osqlite3::close()
{
	if( m_db != NULL )
	{
		m_lasterr = sqlite3_close(m_db);
		m_db = NULL;
	}
}

/*
*** G[bZ[W
*/
const wchar_t* osqlite3::getLastErrMsg()
{
	return (const wchar_t*)sqlite3_errmsg16(m_db);
}

/*
*** f
*/
void osqlite3::interrupt()
{
	sqlite3_interrupt( m_db );
}

/*
*** XVes
*/
int osqlite3::changes()
{
	m_lasterr = sqlite3_changes(m_db);
	return m_lasterr;
}

/*
*** ŏIǉROWID
*/
sqlite3_int64 osqlite3::last_insert_rowid()
{
	return sqlite3_last_insert_rowid( m_db );
}


#ifdef _WIN32_WCE
/*
*** [U`֐쐬
*/
int osqlite3::createfunction( wchar_t* funcname, int iarg, int eTextRep, 
	HANDLE clrevent, osqlite3func** instancepoint, bool xFunc, bool xStep, bool xFinal )
{
	osqlite3func* funccallback = new osqlite3func();
	*instancepoint = funccallback;

	funccallback->SetCLREvent( clrevent );

	//Xg֒ǉ
	m_userfunclist.push_back( funccallback );

	//֐o^
	return sqlite3_create_function16( 
		m_db, 
		funcname, 
		iarg, 
		eTextRep, 
		(void*)funccallback, 
		( xFunc == true ) ? CallFunc:NULL, 
		( xStep == true ) ? CallStep:NULL, 
		( xFinal == true ) ? CallFinal:NULL );
}
#else
/*
*** [U`֐쐬
*/
int osqlite3::createfunction( wchar_t* funcname, int iarg, int eTextRep, 
	void (WINAPI *xFunc)(sqlite3_context*,int,sqlite3_value**),
	void (WINAPI *xStep)(sqlite3_context*,int,sqlite3_value**),
	void (WINAPI *xFinal)(sqlite3_context*) )
{
	osqlite3func* funccallback = new osqlite3func();

	funccallback->SetCallPoint( xFunc, xStep, xFinal );

	//Xg֒ǉ
	m_userfunclist.push_back( funccallback );

	//֐o^
	return sqlite3_create_function16( 
		m_db, 
		funcname, 
		iarg, 
		eTextRep, 
		(void*)funccallback, 
		( xFunc != NULL ) ? CallFunc:NULL, 
		( xStep != NULL ) ? CallStep:NULL, 
		( xFinal != NULL ) ? CallFinal:NULL );
}
#endif

/*
*** XJ[֐ꎞR[obN
*/
void osqlite3::CallFunc( sqlite3_context* a,int b ,sqlite3_value** c )
{
	osqlite3func* funccallback = (osqlite3func*)sqlite3_user_data(a);
	funccallback->CallFunc_Call( a, b, c);
}

/*
*** W֐XebvꎞR[obN
*/
void osqlite3::CallStep( sqlite3_context* a,int b ,sqlite3_value** c )
{
	osqlite3func* funccallback = (osqlite3func*)sqlite3_user_data(a);
	funccallback->CallStep_Call( a, b, c);
}

/*
*** W֐ŏIꎞR[obN
*/
void osqlite3::CallFinal( sqlite3_context* a )
{
	osqlite3func* funccallback = (osqlite3func*)sqlite3_user_data(a);
	funccallback->CallFinal_Call( a );
}

#ifdef _WIN32_WCE
/*
*** [U`ƍ֐쐬
*/
int osqlite3::createcollation( wchar_t* funcname, int eTextRep, HANDLE clrevent, osqlite3collation** instancepoint )
{
	osqlite3collation* collationcallback = new osqlite3collation();
	*instancepoint = collationcallback;

	collationcallback->SetCLREvent( clrevent );

	//Xg֒ǉ
	m_usercollationlist.push_back( collationcallback );

	//֐o^
	return sqlite3_create_collation16( 
		m_db, 
		funcname, 
		eTextRep,
		(void*)collationcallback,
		CallCompare );
}
#else
/*
*** [U`ƍ֐쐬
*/
int osqlite3::createcollation( wchar_t* funcname, int eTextRep, 
	int(WINAPI *xCompare)(void*,int,const void*,int,const void*) )
{
	osqlite3collation* collationcallback = new osqlite3collation();

	collationcallback->SetCallCollation( xCompare );

	//Xg֒ǉ
	m_usercollationlist.push_back( collationcallback );

	//֐o^
	return sqlite3_create_collation16( 
		m_db, 
		funcname, 
		eTextRep,
		(void*)collationcallback,
		CallCompare );
}
#endif

/*
*** [U`ƍ֐ꎞR[obN
*/
int osqlite3::CallCompare(void* NotUsed,int nKey1,const void* pKey1,int nKey2,const void* pKey2)
{
	osqlite3collation* collationcallback = (osqlite3collation*)NotUsed;
	return collationcallback->CallCollation_Call( NotUsed, nKey1, pKey1, nKey2, pKey2 );
}
