using System;
using System.ComponentModel;
using System.IO;
using System.Collections;
using System.Data;

using SQLiteCSLib.Inner;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLiteR}h
	/// </summary>
	public class SQLiteCommand : Component, IDbCommand, IDisposable
	{
		/// <summary>
		/// SQLiteڑ
		/// </summary>
		protected SQLiteConnection m_connect = null;

		/// <summary>
		/// SQLitegUNV
		/// </summary>
		protected SQLiteTransaction m_transaction = null;

		/// <summary>
		/// p[^Xg
		/// </summary>
		protected SQLiteParameterCollection m_collection = new SQLiteParameterCollection();

		/// <summary>
		/// SQLeLXg
		/// </summary>
		protected string m_command = "";

		/// <summary>
		/// R}h\
		/// </summary>
		protected OSQLiteStmtWrap m_stmt = null;

		/// <summary>
		/// \񊮗
		/// </summary>
		protected bool m_prepare = false;

		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteCommand()
		{
		}

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="connect">SQLiteڑ</param>
		public SQLiteCommand( SQLiteConnection connect )
		{
			m_connect = connect;
		}

		/// <summary>
		/// LZ
		/// Ŝɉe
		/// </summary>
		public void Cancel()
		{
			m_connect.OSQLiteDB.Interrupt();
		}

		/// <summary>
		/// R}h\
		/// SQLR}hׂɁAݒ肳ꂽp[^oChp[^ɃZbg܂B
		/// </summary>
		public void Prepare()
		{
			m_stmt = m_connect.OSQLiteDB.CreateStmt();

			m_prepare = m_stmt.Prepate( m_command );

			//p[^oCh
			bindparams( m_stmt );

			if( m_connect.OSQLiteDB.getLastErr() != ResultEnum.DONE &&
				m_connect.OSQLiteDB.getLastErr() != ResultEnum.ROW &&
				m_connect.OSQLiteDB.getLastErr() != ResultEnum.OK )
			{
				//G[
				throw new SQLiteException( m_connect );
			}
		}

		/// <summary>
		/// p[^oCh
		/// </summary>
		/// <param name="stmt">STMTbp[</param>
		protected void bindparams( OSQLiteStmtWrap stmt )
		{
			int iCnt = 1;

			ArrayList paramlist = new ArrayList( Parameters );
			paramlist.Sort();

			stmt.Reset();

			//oChϐZbg
			foreach( SQLiteParameter para in paramlist )
			{
				//NULLl
				if( para.Value == null )
				{
					stmt.bindNull( iCnt );
				}
				else
					if( para.DbType == DbType.String )
				{
					stmt.bindText( iCnt, (string)para.Value );
				}
				else
					if( para.DbType == DbType.Int64 )
				{
					stmt.bindInt64( iCnt, (long)para.Value );
				}
				else
					if( para.DbType == DbType.Int32 || para.DbType == DbType.Int16 )
				{
					stmt.bindInt( iCnt, (int)para.Value );
				}
				else
					if( para.DbType == DbType.Boolean )
				{
					stmt.bindBool( iCnt, (bool)para.Value );
				}
				else
					if( para.DbType == DbType.Double )
				{
					stmt.bindDouble( iCnt, (double)para.Value );
				}
				else
					if( para.DbType == DbType.Decimal )
				{
					stmt.bindDecimal( iCnt, (decimal)para.Value );
				}
				else
					if( para.DbType == DbType.Binary )
				{
					byte[] bindbin = (byte[])para.Value;
					stmt.bindBlob( iCnt, new MemoryStream( bindbin ) );
				}

				iCnt++;
			}		
		}

		/// <summary>
		/// R}h^Cv
		/// </summary>
		protected CommandType m_cmdtype = CommandType.Text;

		/// <summary>
		/// R}h^CvvpeB
		/// T|[g
		/// </summary>
		public System.Data.CommandType CommandType
		{
			get
			{
				return m_cmdtype;
			}
			set
			{
				m_cmdtype = value;
			}
		}

		/// <summary>
		/// ǍSQLs
		/// R}h\񂵂ĂȂꍇAR}h\sB
		/// sAp[^Zbg܂B
		/// T|[g
		/// </summary>
		/// <param name="behavior">f[^x[Xɗ^e</param>
		/// <returns>SQLitef[^[_</returns>
		public IDataReader ExecuteReader(CommandBehavior behavior)
		{
			if( m_prepare == false )
			{
				Prepare();
			}

			if( m_prepare == false )
			{
				//s
				throw new SQLiteException( m_connect );
			}

			OSQLiteStmtWrap stmt = m_stmt;
			m_stmt = null;

			m_prepare = false;

			m_collection = new SQLiteParameterCollection();

			return new SQLiteDataReader( stmt );
		}

		/// <summary>
		/// ǍSQLs
		/// R}h\񂵂ĂȂꍇAR}h\sB
		/// sAp[^Zbg܂B
		/// </summary>
		/// <returns>SQLitef[^[_</returns>
		IDataReader System.Data.IDbCommand.ExecuteReader()
		{
			return ExecuteReader( CommandBehavior.Default );
		}

		/// <summary>
		/// PsʗpSQLs
		/// R}h\񂵂ĂȂꍇAR}h\sB
		/// sAp[^Zbg܂B
		/// </summary>
		/// <returns>sʒl</returns>
		public object ExecuteScalar()
		{
			using ( IDataReader ir = ExecuteReader( CommandBehavior.Default ) )
			{
				ir.Read();

				if( m_connect.OSQLiteDB.getLastErr() != ResultEnum.DONE &&
					m_connect.OSQLiteDB.getLastErr() != ResultEnum.ROW &&
					m_connect.OSQLiteDB.getLastErr() != ResultEnum.OK )
				{
					//G[
					throw new SQLiteException( m_connect );
				}

				return ir.GetValue(0);
			}
		}

		/// <summary>
		/// SQLs
		/// R}h\s܂B
		/// sAp[^Zbg܂B
		/// </summary>
		/// <returns>es</returns>
		public int ExecuteNonQuery()
		{
			using( OSQLiteStmtWrap stmt = m_connect.OSQLiteDB.CreateStmt() )
			{
				if( stmt.Prepate( m_command ) == false )
				{
					if( m_connect.OSQLiteDB.getLastErr() != ResultEnum.DONE &&
						m_connect.OSQLiteDB.getLastErr() != ResultEnum.ROW &&
						m_connect.OSQLiteDB.getLastErr() != ResultEnum.OK )
					{
						//G[
						throw new SQLiteException( m_connect );
					}

					return 0;
				}

				//p[^oCh
				bindparams( stmt );

				m_stmt = null;
				m_prepare = false;
				m_collection = new SQLiteParameterCollection();

				//ʃZbgJEg
				int iCnt=0;
				while( stmt.Step() == ResultEnum.ROW ) iCnt++;

				return iCnt;
			}
		}

		/// <summary>
		/// ^CAEgvpeB
		/// T|[g
		/// </summary>
		public int CommandTimeout
		{
			get
			{
				return 0;
			}
			set
			{
			}
		}

		/// <summary>
		/// p[^쐬
		/// </summary>
		/// <returns></returns>
		public IDbDataParameter CreateParameter()
		{
			return new SQLiteParameter();
		}

		/// <summary>
		/// ڑvpeB
		/// </summary>
		public IDbConnection Connection
		{
			get
			{
				return m_connect;
			}
			set
			{
				m_connect = value as SQLiteConnection;
			}
		}

		/// <summary>
		/// XVšʂɑ΂Kp@
		/// </summary>
		protected UpdateRowSource m_urs = UpdateRowSource.None;

		/// <summary>
		/// XVšʂɑ΂Kp@vpeB
		/// T|[g
		/// </summary>
		public UpdateRowSource UpdatedRowSource
		{
			get
			{
				return m_urs;
			}
			set
			{
				m_urs = value;
			}
		}

		/// <summary>
		/// SQLR}h
		/// </summary>
		public string CommandText
		{
			get
			{
				return m_command;
			}
			set
			{
				m_command = value;
			}
		}

		/// <summary>
		/// p[^XgvpeB
		/// </summary>
		public IDataParameterCollection Parameters
		{
			get
			{
				return m_collection;
			}
		}

		/// <summary>
		/// gUNVvpeB
		/// </summary>
		public IDbTransaction Transaction
		{
			get
			{
				return m_transaction;
			}
			set
			{
				m_transaction = value as SQLiteTransaction;
			}
		}

		/// <summary>
		/// fXgN^
		/// </summary>
		new public void Dispose()
		{
			m_stmt = null;
		}
		#region ICloneable o

		public object Clone()
		{
			// TODO:  SQLiteCommand.Clone ǉ܂B
			return null;
		}

		#endregion
	}
}
