using System;
using System.Collections;
using System.Data;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLitep[^RNV
	/// </summary>
	public class SQLiteParameterCollection : ArrayList, IDataParameterCollection
	{
		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteParameterCollection()
		{
		}

		/// <summary>
		/// p[^vpeB
		/// </summary>
		public object this[string parameterName]
		{
			get
			{
				foreach( IDataParameter idp in this )
				{
					if( idp.ParameterName == parameterName )
						return idp;
				}

				return null;
			}
			set
			{
				IDataParameter target = null;
				foreach( IDataParameter idp in this )
				{
					if( idp.ParameterName == parameterName )
						target = idp;
				}

				if( target != null )
				{
					this.Remove( target );
					this.Add( value );
				}
			}
		}

		/// <summary>
		/// p[^폜
		/// </summary>
		/// <param name="parameterName"></param>
		public void RemoveAt(string parameterName)
		{
			IDataParameter target = null;
			foreach( IDataParameter idp in this )
			{
				if( idp.ParameterName == parameterName )
					target = idp;
			}

			if( target != null )
			{
				this.Remove( target );
			}
		}

		/// <summary>
		/// p[^݃`FbN
		/// </summary>
		/// <param name="parameterName"></param>
		/// <returns></returns>
		public bool Contains(string parameterName)
		{
			foreach( IDataParameter idp in this )
			{
				if( idp.ParameterName == parameterName )
					return true;
			}

			return false;
		}

		/// <summary>
		/// zԍ擾
		/// </summary>
		/// <param name="parameterName"></param>
		/// <returns></returns>
		public int IndexOf(string parameterName)
		{
			for( int iIdx = 0; iIdx<this.Count; iIdx++ )
			{
				IDataParameter idp = this[ iIdx ] as IDataParameter;
				if( idp != null && idp.ParameterName == parameterName )
					return iIdx;
			}

			return -1;
		}
	}
}
