using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.Common;

namespace SQLiteCSLib
{
	/// <summary>
	/// SQLite f[^A_v^
	/// </summary>
	public class SQLiteDataAdapter : Component, IDbDataAdapter
	{
		/// <summary>
		/// RXgN^
		/// </summary>
		public SQLiteDataAdapter()
		{
		}

		#region IDbDataAdapter

		/// <summary>
		/// XVR}h
		/// </summary>
		protected IDbCommand m_updatecmd = null;

		/// <summary>
		/// XVR}hvpeB
		/// </summary>
		public IDbCommand UpdateCommand
		{
			get
			{
				return m_updatecmd;
			}
			set
			{
				m_updatecmd = value;
			}
		}

		/// <summary>
		/// R}h
		/// </summary>
		protected IDbCommand m_selectcmd = null;

		/// <summary>
		/// R}hvpeB
		/// </summary>
		public IDbCommand SelectCommand
		{
			get
			{
				return m_selectcmd;
			}
			set
			{
				m_selectcmd = value;
			}
		}

		/// <summary>
		/// 폜R}h
		/// </summary>
		protected IDbCommand m_deletecmd = null;

		/// <summary>
		/// 폜R}hvpeB
		/// </summary>
		/// </summary>
		public IDbCommand DeleteCommand
		{
			get
			{
				return m_deletecmd;
			}
			set
			{
				m_deletecmd = value;
			}
		}

		/// <summary>
		/// ǉR}h
		/// </summary>
		protected IDbCommand m_insertcmd = null;

		/// <summary>
		/// ǉR}hvpeB
		/// </summary>
		public IDbCommand InsertCommand
		{
			get
			{
				return m_insertcmd;
			}
			set
			{
				m_insertcmd = value;
			}
		}

		#endregion

		#region IDataAdapter

		/// <summary>
		/// Tablef[^e[u쐬
		/// </summary>
		/// <param name="dataSet">R[hѕKvɉăXL[}i[</param>
		/// <returns>s</returns>
		public int Fill(DataSet dataSet)
		{
			int iRet = 0;

			using( IDataReader reader = SelectCommand.ExecuteReader() )
			{
				DataTable dt = reader.GetSchemaTable();
				
				if( dataSet.Tables.Count > 0 )
					dt.TableName = "Table"+dataSet.Tables.Count.ToString();
				else
					dt.TableName = "Table";

				iRet = dt.Rows.Count;

				dataSet.Tables.Add( dt );
			}

			return iRet;
		}

		/// <summary>
		/// TableMappingsRNV
		/// </summary>
		public ITableMappingCollection TableMappings
		{
			get
			{
#if !MOBILEPC
				return new DataTableMappingCollection();
#else
				return null;
#endif
			}
		}

		/// <summary>
		/// MissingSchemaAction
		/// </summary>
		protected MissingSchemaAction m_msa = MissingSchemaAction.Add;

		/// <summary>
		/// MissingSchemaAction
		/// </summary>
		public MissingSchemaAction MissingSchemaAction
		{
			get
			{
				return m_msa;
			}
			set
			{
				m_msa = value;
			}
		}

		/// <summary>
		/// MissingMappingAction
		/// </summary>
		protected MissingMappingAction m_mma = MissingMappingAction.Passthrough;

		/// <summary>
		/// MissingMappingAction
		/// </summary>
		public MissingMappingAction MissingMappingAction
		{
			get
			{
				return m_mma;
			}
			set
			{
				m_mma = value;
			}
		}

		/// <summary>
		/// SQL SELECT Xe[gg̎sɃ[U[ݒ肵p[^擾܂B
		/// </summary>
		/// <returns></returns>
		public IDataParameter[] GetFillParameters()
		{
			ArrayList list = m_selectcmd.Parameters as ArrayList;
			return list.ToArray( typeof( IDataParameter ) ) as IDataParameter[];
		}

		/// <summary>
		/// Tablef[^e[u쐬
		/// </summary>
		/// <param name="dataSet"></param>
		/// <param name="schemaType"></param>
		/// <returns></returns>
		public DataTable[] FillSchema(DataSet dataSet, System.Data.SchemaType schemaType)
		{
			using( SQLiteDataReader reader = SelectCommand.ExecuteReader() as SQLiteDataReader )
			{
				DataTable dt = reader.GetSchemaTable();

				dataSet.Tables.Add( dt );

				return new DataTable[]{dt};
			}
		}

		/// <summary>
		/// XV
		/// </summary>
		/// <param name="dataSet"></param>
		/// <returns></returns>
		public int Update(DataSet dataSet)
		{
			foreach( DataTable dt in dataSet.Tables )
			{
				foreach( DataRow dr in dt.Rows )
				{
					switch( dr.RowState )
					{
						case DataRowState.Added:
							foreach( DataColumn dc in dt.Columns )
							{
								InsertCommand.Parameters.Add( dr.ItemArray[ dc.Ordinal ] );
							}

							return InsertCommand.ExecuteNonQuery();

						case DataRowState.Deleted:
							foreach( DataColumn dc in dt.Columns )
							{
								DeleteCommand.Parameters.Add( dr.ItemArray[ dc.Ordinal ] );
							}

							return InsertCommand.ExecuteNonQuery();


						case DataRowState.Modified:
							foreach( DataColumn dc in dt.Columns )
							{
								DeleteCommand.Parameters.Add( dr.ItemArray[ dc.Ordinal ] );
							}

							return UpdateCommand.ExecuteNonQuery();

					}
				}
			}

			return 0;
		}

		#endregion
	}
}
