using System;
using System.Runtime.InteropServices;

namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// ϊ A}l[W}l[W
	/// </summary>
	public class StringFromC
	{
		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		unsafe static public string String( void* str )
		{
			IntPtr ValPtr = new IntPtr( str );
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr );
#else
			return Marshal.PtrToStringAuto( ValPtr );
#endif
		}

		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		unsafe static public string String( IntPtr ValPtr )
		{
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr );
#else
			return Marshal.PtrToStringAuto( ValPtr );
#endif
		}

		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		/// <param name="str"></param>
		/// <param name="isize"></param>
		/// <returns></returns>
		unsafe static public string String( void* str, int isize )
		{
			IntPtr ValPtr = new IntPtr( str );
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr, isize );
#else
			return Marshal.PtrToStringAuto( ValPtr, isize );
#endif
		}

		/// <summary>
		/// A}l[WUTFϊ
		/// </summary>
		/// <param name="str"></param>
		/// <param name="isize"></param>
		/// <returns></returns>
		unsafe static public string String( IntPtr ValPtr, int isize )
		{
#if MOBILEPC
			return Marshal.PtrToStringUni( ValPtr, isize );
#else
			return Marshal.PtrToStringAuto( ValPtr, isize );
#endif
		}
	}
}
