/*
 * Decompiled with CFR 0.152.
 */
package org.sql.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.sql.util.ReplaceUtil;

public final class GeneratorUtil {
    private static final String RESOURCES = "org.sql.Resources";

    private GeneratorUtil() {
    }

    public static boolean isNaming(String name) {
        boolean result = true;
        for (int i = 0; i < name.length(); ++i) {
            char charData = name.charAt(i);
            if (charData >= 'A' && charData <= 'Z' || charData >= 'a' && charData <= 'z' || charData >= '0' && charData <= '9' || charData == '-' || charData == '_') continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isExclusion(String value) {
        return value.indexOf("{") > -1 && value.indexOf("}") > -1;
    }

    public static String getExclusion(String value) {
        String str = value.substring(1, value.length());
        return str.substring(0, str.length() - 1);
    }

    public static Timestamp parseStamp(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return new Timestamp(cal.getTimeInMillis());
    }

    public static String dateToStr(Date date, String fmt) {
        SimpleDateFormat SD = new SimpleDateFormat(fmt, Locale.JAPAN);
        String sYMD = SD.format(date);
        if (sYMD == null) {
            sYMD = "";
        }
        return sYMD;
    }

    public static String toQuoteString(Object object) {
        return object instanceof String ? "'" + object.toString() + "'" : object.toString();
    }

    public static String toExclusionString(Object object) {
        return GeneratorUtil.isExclusion(object.toString()) ? GeneratorUtil.getExclusion(object.toString()) : GeneratorUtil.toQuoteString(object);
    }

    public static String formatExclusion(String arg) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCES, Locale.JAPAN);
        return ReplaceUtil.replace(bundle.getString("format.exclusion"), arg);
    }
}

