/*
 * Decompiled with CFR 0.152.
 */
package org.sql.type;

import java.util.Map;
import org.sql.type.Types;
import org.sql.util.GeneratorUtils;

public class Function
implements Types {
    private String function;
    private String column;

    protected Function(String function, String column) {
        this.function = function;
        this.column = column;
    }

    public String toTypeString() {
        StringBuffer str = new StringBuffer();
        str.append(this.function);
        str.append("(");
        str.append(this.column);
        str.append(")");
        return str.toString();
    }

    public static Function sum(String column) {
        return new Function("SUM", column);
    }

    public static Function max(String column) {
        return new Function("MAX", column);
    }

    public static Function min(String column) {
        return new Function("MIN", column);
    }

    public static Function avg(String column) {
        return new Function("AVG", column);
    }

    public static Function count(String column) {
        return new Function("COUNT", column);
    }

    public static Function decode(String column, Map map, Object def) {
        StringBuffer str = new StringBuffer(column);
        Object[] key = map.keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            str.append("," + GeneratorUtils.toQuoteString(key[i]));
            str.append("," + GeneratorUtils.toQuoteString(map.get(key[i])));
        }
        str.append(", ");
        str.append(GeneratorUtils.toQuoteString(def));
        return new Function("DECODE", str.toString());
    }

    public static Function nvl(String column, Object def) {
        return Function.createFunction("NVL", new Object[]{"{" + column + "}", def});
    }

    public static Function nvl2(String column, Object result1, Object result2) {
        return Function.createFunction("NVL2", new Object[]{"{" + column + "}", result1, result2});
    }

    public static Function abs(Object column) {
        return Function.createFunction("ABS", new Object[]{column});
    }

    public static Function round(Object column) {
        return Function.createFunction("ROUND", new Object[]{column});
    }

    public static Function round(Object column, int digit) {
        return Function.createFunction("ROUND", new Object[]{column, new Integer(digit)});
    }

    public static Function trunc(Object column) {
        return Function.createFunction("TRUNC", new Object[]{column});
    }

    public static Function trunc(Object column, int digit) {
        return Function.createFunction("TRUNC", new Object[]{column, new Integer(digit)});
    }

    public static Function mod(Object column, int num) {
        return Function.createFunction("MOD", new Object[]{column, new Integer(num)});
    }

    public static Function trim(String column) {
        return Function.createFunction("TRIM", new Object[]{column});
    }

    public static Function ltrim(String column) {
        return Function.createFunction("LTRIM", new Object[]{column});
    }

    public static Function rtrim(String column) {
        return Function.createFunction("RTRIM", new Object[]{column});
    }

    public static Function toDate(String column, String format) {
        return Function.createFunction("TO_DATE", new Object[]{column, format});
    }

    public static Function toChar(Object column, String format) {
        return Function.createFunction("TO_CHAR", new Object[]{column, format});
    }

    public static Function toNumber(String column, String format) {
        return Function.createFunction("TO_NUMBER", new Object[]{column, format});
    }

    public static Function upper(String column) {
        return Function.createFunction("UPPER", new Object[]{column});
    }

    public static Function lower(String column) {
        return Function.createFunction("LOWER", new Object[]{column});
    }

    public static Function initcap(String column) {
        return Function.createFunction("INITCAP", new Object[]{column});
    }

    public static Function concat(String arg0, String arg1) {
        return Function.createFunction("CONCAT", new Object[]{arg0, arg1});
    }

    public static Function substr(String column, int arg0, int arg1) {
        return Function.createFunction("SUBSTR", new Object[]{column, new Integer(arg0), new Integer(arg1)});
    }

    public static Function length(String column) {
        return Function.createFunction("LENGTH", new Object[]{column});
    }

    public static Function instr(String column, String arg) {
        return Function.createFunction("INSTR", new Object[]{column, arg});
    }

    public static Function instr(String column, String arg0, int arg1) {
        return Function.createFunction("INSTR", new Object[]{column, arg0, new Integer(arg1)});
    }

    public static Function instr(String column, String arg0, int arg1, int arg2) {
        return Function.createFunction("INSTR", new Object[]{column, arg0, new Integer(arg1), new Integer(arg2)});
    }

    public static Function lpad(String column, int arg) {
        return Function.createFunction("LPAD", new Object[]{column, new Integer(arg), " "});
    }

    public static Function lpad(String column, int arg0, String arg1) {
        return Function.createFunction("LPAD", new Object[]{column, new Integer(arg0), arg1});
    }

    public static Function rpad(String column, int arg) {
        return Function.createFunction("RPAD", new Object[]{column, new Integer(arg), " "});
    }

    public static Function rpad(String column, int arg0, String arg1) {
        return Function.createFunction("RPAD", new Object[]{column, new Integer(arg0), arg1});
    }

    public static Function replace(String column, String arg0, String arg1) {
        return Function.createFunction("REPLACE", new Object[]{column, arg0, arg1});
    }

    public static Function createFunction(String function, Object[] args) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (str.toString().length() > 0) {
                str.append(", ");
            }
            str.append(GeneratorUtils.toExclusionString(args[i]));
        }
        return new Function(function, str.toString());
    }
}

