/*
 * Decompiled with CFR 0.152.
 */
package org.sql.generator;

import java.util.Map;
import org.sql.column.RegistColumn;
import org.sql.exception.GeneratorException;
import org.sql.generator.BaseSimpleSql;
import org.sql.message.Message;
import org.sql.util.GeneratorUtils;

public class InsertSql
extends BaseSimpleSql {
    public InsertSql(String table) {
        super(table);
    }

    public InsertSql(String table, RegistColumn column) {
        super(table);
        super.setColumn(column);
    }

    protected String createSql(boolean bind) throws GeneratorException {
        StringBuffer result = new StringBuffer();
        if (!GeneratorUtils.isNaming(this.getFrom())) {
            throw new GeneratorException(Message.getInstance("SQL-001", this.getFrom()));
        }
        result.append("INSERT INTO " + this.getFrom());
        result.append(" (" + this.getColumnString() + ")");
        result.append(" VALUES (");
        if (bind) {
            result.append(this.getBindVariable());
        } else {
            result.append(this.getValue());
        }
        result.append(")");
        return result.toString();
    }

    protected String getBindVariable() {
        StringBuffer result = new StringBuffer();
        Object[] key = super.getColumn().getMap().keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("?");
        }
        return result.toString();
    }

    private String getColumnString() {
        StringBuffer result = new StringBuffer();
        Object[] key = super.getColumn().getMap().keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(key[i]);
        }
        return result.toString();
    }

    private String getValue() {
        StringBuffer result = new StringBuffer();
        Map map = super.getColumn().getMap();
        Object[] key = map.keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            if (result.length() > 0) {
                result.append(", ");
            }
            if (map.get(key[i]) == null) {
                result.append("NULL");
                continue;
            }
            if (map.get(key[i]) instanceof String) {
                result.append("'");
                result.append(map.get(key[i]));
                result.append("'");
                continue;
            }
            result.append(map.get(key[i]));
        }
        return result.toString();
    }
}

