/*
 * Decompiled with CFR 0.152.
 */
package org.sql.condition;

import org.sql.comparison.Comparison;
import org.sql.condition.Conditionable;
import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.item.DefaultItems;
import org.sql.item.Item;
import org.sql.item.Items;

public abstract class AbstractCondition
implements Conditionable {
    protected static final String WHERE = " WHERE ";
    protected static final String AND = " AND ";
    protected static final String OR = " OR ";
    private Items condition = new DefaultItems();
    private Throwable exception = null;

    public void and(Comparison comparison) {
        this.createCondition(comparison, AND);
    }

    public void or(Comparison comparison) {
        this.createCondition(comparison, OR);
    }

    public String getCondition() throws ComparisonException {
        if (this.exception != null) {
            throw new ComparisonException(this.exception);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.condition.size(); ++i) {
            Item item = this.condition.get(i);
            Comparison comparison = (Comparison)item.getValue()[0];
            sb.append(item.getColumn());
            sb.append(comparison.toComparisonString());
        }
        return sb.toString();
    }

    public void clear() {
        this.condition = null;
        this.condition = new DefaultItems();
    }

    public boolean isEmpty() {
        return this.condition.isEmpty();
    }

    protected void setCondition(String condition, Comparison comparison) {
        DefaultItem item = new DefaultItem();
        item.put(condition, comparison);
        this.condition.put(item);
    }

    protected void setException(Throwable exception) {
        this.exception = exception;
    }

    protected abstract void createCondition(Comparison var1, String var2);

    protected final Items getConditionItems() {
        return this.condition;
    }
}

