/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import org.sql.comparison.BaseBindComparison;
import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.type.LikeMatch;
import org.sql.util.GeneratorUtils;

public class LikeComparison
extends BaseBindComparison {
    public LikeComparison(String column, LikeMatch match) {
        this.setComparison(column, match);
    }

    public void setComparison(String column, LikeMatch match) {
        DefaultItem item = new DefaultItem();
        item.put(column, match.toTypeString());
        super.setComparison(item);
    }

    protected String createComparison(DefaultItem item) throws ComparisonException {
        return this.createComparison(item, false);
    }

    protected String createBindComparison(DefaultItem item) throws ComparisonException {
        return this.createComparison(item, true);
    }

    private String createComparison(DefaultItem item, boolean bind) throws ComparisonException {
        StringBuffer sb = new StringBuffer();
        sb.append(item.getColumn());
        sb.append(" like ");
        sb.append(bind ? "?" : GeneratorUtils.toQuoteString(item.getValue()[0]));
        return sb.toString();
    }
}

