/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.List;
import org.sql.comparison.BaseBindComparison;
import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.util.GeneratorUtils;

public class InComparison
extends BaseBindComparison {
    public InComparison(String column, List value) {
        this(column, value.toArray());
    }

    public InComparison(String column, Object[] value) {
        this.setComparison(column, value);
    }

    protected void setComparison(String column, Object[] value) {
        DefaultItem item = new DefaultItem();
        item.put(column, value);
        super.setComparison(item);
    }

    protected String createComparison(DefaultItem item) throws ComparisonException {
        return this.createComparison(item, false);
    }

    protected String createBindComparison(DefaultItem item) throws ComparisonException {
        return this.createComparison(item, true);
    }

    private String createComparison(DefaultItem item, boolean bind) throws ComparisonException {
        StringBuffer sb = new StringBuffer();
        sb.append(item.getColumn());
        sb.append(" IN (");
        for (int i = 0; i < item.size(); ++i) {
            sb.append(bind ? "?" : GeneratorUtils.toQuoteString(item.getValue()[i]));
            if (i == item.size() - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

