/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.ArrayList;
import java.util.Arrays;
import org.sql.comparison.BaseBindComparison;
import org.sql.exception.ComparisonException;
import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;
import org.sql.item.DefaultItem;

public class ExistsComparison
extends BaseBindComparison {
    private boolean not = false;

    public ExistsComparison(Sql sql) {
        this.setComparison(sql, false);
    }

    public ExistsComparison(Sql sql, boolean not) {
        this.setComparison(sql, true);
    }

    public Object[] getParameter() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] parameter = super.getParameter();
        for (int i = 0; i < parameter.length; ++i) {
            result.addAll(Arrays.asList(((Sql)parameter[i]).getParameter()));
        }
        return result.toArray();
    }

    protected void setComparison(Sql sql, boolean not) {
        DefaultItem item = new DefaultItem();
        item.put(null, sql);
        super.setComparison(item);
        this.not = not;
    }

    protected String createComparison(DefaultItem item) throws ComparisonException {
        return this.createComparison(item, false);
    }

    protected String createBindComparison(DefaultItem item) throws ComparisonException {
        return this.createComparison(item, true);
    }

    private String createComparison(DefaultItem item, boolean bind) throws ComparisonException {
        StringBuffer sb = new StringBuffer();
        Sql sql = (Sql)item.getValue()[0];
        try {
            if (this.not) {
                sb.append("NOT ");
            }
            sb.append("EXISTS (");
            sb.append(bind ? sql.getBindSql() : sql.getSql());
            sb.append(")");
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
        return sb.toString();
    }
}

