/*
 * Decompiled with CFR 0.152.
 */
package org.sql.comparison;

import java.util.Date;
import org.sql.comparison.Comparison;
import org.sql.exception.ComparisonException;
import org.sql.exception.FormatException;
import org.sql.item.DefaultItem;
import org.sql.type.Format;
import org.sql.type.Function;
import org.sql.util.GeneratorUtils;

public abstract class AbstractComparison
implements Comparison {
    private DefaultItem comparison = new DefaultItem();
    private Throwable exception = null;

    protected AbstractComparison() {
    }

    public String toComparisonString() throws ComparisonException {
        if (this.exception != null) {
            throw new ComparisonException(this.exception);
        }
        return this.createComparison(this.comparison);
    }

    public void clear() {
        this.comparison = null;
    }

    public Throwable getException() {
        return this.exception;
    }

    protected void setComparison(DefaultItem comparison) {
        this.comparison = comparison;
    }

    protected String toDate(Date value, Format format) throws FormatException {
        String todate = GeneratorUtils.dateToStr(value, format.getConvertFormat());
        return Function.toDate(todate, format.toTypeString()).toTypeString();
    }

    protected void setException(Throwable exception) {
        this.exception = exception;
    }

    protected abstract String createComparison(DefaultItem var1) throws ComparisonException;
}

