/*
 * Decompiled with CFR 0.152.
 */
package org.sql.column;

import java.util.LinkedHashMap;
import java.util.Map;
import org.sql.column.BaseColumn;
import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;

public abstract class BaseSelectColumn
extends BaseColumn {
    private Map map = new LinkedHashMap();

    public void append(String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            this.append(columns[i]);
        }
    }

    public void append(Object column) {
        this.append(column, null);
    }

    public void append(Object column, String as) {
        this.map.put(column, as);
    }

    public void append(String[] columns, String[] as) {
        for (int i = 0; i < columns.length; ++i) {
            this.append(columns[i], as[i]);
        }
    }

    public String toColumnString() {
        this.createColumn(false);
        return super.toColumnString();
    }

    public String toBindColumnString() {
        this.createColumn(true);
        return super.toColumnString();
    }

    protected void createColumn(boolean bind) throws GeneratorException {
        StringBuffer buffer = new StringBuffer();
        super.clear();
        if (this.map.isEmpty()) {
            super.append("*");
            return;
        }
        Object[] key = this.map.keySet().toArray();
        for (int i = 0; i < key.length; ++i) {
            Object column = key[i];
            if (column instanceof Sql) {
                Sql sql = (Sql)column;
                buffer.append("(");
                buffer.append(bind ? sql.getBindSql() : sql.getSql());
                buffer.append(")");
            } else {
                buffer.append(column);
            }
            if (this.map.get(column) != null) {
                buffer.append(" AS ");
                buffer.append(this.map.get(column).toString());
            }
            super.append(buffer.toString());
            buffer.delete(0, buffer.toString().length());
        }
    }
}

