/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * O[vǗNX.
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.5 $ $Date: 2006/04/08 08:22:25 $
 */
public class Group implements Types {

	/** O[vsJz */
	private String[] columns;
	/** WvʏIuWFNg */
	private Having having;
	
	/**
	 * RXgN^
	 * @param columns Jz
	 */
	protected Group(String[] columns) {
		this.columns = columns;
	}

	/**
	 * RXgN^
	 * @param columns Jz
	 * @param having WvʏIuWFNg
	 */
	protected Group(String[] columns, Having having) {
		this(columns);
		this.having = having;
	}
	
	/**
	 * ʕ擾
	 * @return ʕ
	 */
	public String toTypeString() {
		StringBuffer str = new StringBuffer();
		for (int i = 0; i < this.columns.length; i++) {
		    if (str.toString().length() > 0) {
		        str.append(", ");
		    }
		    str.append(this.columns[i]);
		}
		if (this.having != null) {
		    str.append(" HAVING ");
		    str.append(this.having.toTypeString());
		}
		return str.toString();
	}

	/**
	 * O[vJݒ肷
	 *
	 * @param column J
	 * @return O[vIuWFNg
	 */
	public static Group groupBy(String column) {
		return new Group(new String[] {column});
	}

	/**
	 * O[vJݒ肷
	 *
	 * @param columns Jz
	 * @return O[vIuWFNg
	 */
	public static Group groupBy(String[] columns) {
		return new Group(columns);
	}
	
	/**
	 * O[vJݒ肷
	 *
	 * @param column J
	 * @param having WvʏIuWFNg
	 * @return O[vIuWFNg
	 */
	public static Group groupBy(String column, Having having) {
		return new Group(new String[] {column});
	}

	/**
	 * O[vJݒ肷
	 *
	 * @param columns Jz
	 * @param having WvʏIuWFNg
	 * @return O[vIuWFNg
	 */
	public static Group groupBy(String[] columns, Having having) {
		return new Group(columns);
	}
}
