/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * ǗNX.
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.6 $ $Date: 2006/04/08 08:22:25 $
 */
public class Format implements Types {

    /**  */
	private int formatMode;

	/** [h - N */
	private static final int ORA_YMD = 0;
	/** [h - b */
	private static final int ORA_HMS = 1;
	/** [h - Nb */
	private static final int ORA_YMD_HMS = 2;

	/** t - N */
	private static String JAVA_YMD = "yyyy/MM/dd";
	/** t - b */
	private static String JAVA_HMS = "HH:mm:ss";
	/** t - Nb */
	private static String JAVA_YMD_HMS = "yyyy/MM/dd HH:mm:ss";
	
	/** t - N */
	public static final Format YMD = new Format(ORA_YMD);
	/** t - b */
	public static final Format HMS = new Format(ORA_HMS);
	/** t - Nb */
	public static final Format YMD_HMS = new Format(ORA_YMD_HMS);

	
	/**
	 * RXgN^
	 * @param formatMode [h
	 */
	protected Format(int formatMode) {
		this.formatMode = formatMode;
	}
	
	/**
	 * 擾
	 * @return 
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.formatMode) {
			case ORA_YMD: ret = "YYYY/MM/DD"; break;
			case ORA_HMS: ret = "HH24:MI:SS"; break;
			case ORA_YMD_HMS: ret = "YYYY/MM/DD HH24:MI:SS"; break;
		}
		return ret;
	}
	
	/**
	 * ϊ擾
	 * @return ϊ
	 */
	public String getConvertFormat() {
		String ret = null;
		switch (this.formatMode) {
			case ORA_YMD: ret = JAVA_YMD; break;
			case ORA_HMS: ret = JAVA_HMS; break;
			case ORA_YMD_HMS: ret = JAVA_YMD_HMS; break;
		}
		return ret;
	}
}