/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import java.util.Map;

import org.sql.column.RegistColumn;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.util.GeneratorUtils;


/**
 * ǉSQLNX.
 * 
 * <P>
 * XVAe[uݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">INSERT INTO TABLE1 (COLUMN1, COLUMN2) VALUES ('', '')</font><br>
 *         <br>
 *         @RegistColumn column = new RegistColumn();<br>
 *         @column.append("COLUMN1", "");<br>
 *         @column.append("COLUMN2", "");<br>
 *         <br>
 *         @InsertSql sql = new InsertSql("TABLE1", column);<br>
 * </td></tr></table>
 * <P>
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.10 $ $Date: 2006/04/08 08:48:16 $
 */
public class InsertSql extends BaseSimpleSql {

	/**
	 * RXgN^
	 * @param table e[u
	 */
	public InsertSql(String table) {
		super(table);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column XVJ
	 */
	public InsertSql(String table, RegistColumn column) {
		super(table);
		super.setColumn(column);
	}
	
	/**
	 * SQL쐬
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	protected String createSql(boolean bind) throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (!GeneratorUtils.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("INSERT INTO " + getFrom());
		result.append(" (" + getColumnString() + ")");
		result.append(" VALUES (");
		if (bind) {
			result.append(getBindVariable());
		}
		else {
			result.append(getValue());
		}
		result.append(")");
		return result.toString();
	}
	
	/**
	 * oChϐ擾
	 * @return oChϐ
	 */
	protected String getBindVariable() {
		StringBuffer result = new StringBuffer();
		Object[] key = super.getColumn().getMap().keySet().toArray();
		for (int i = 0; i < key.length; i++) {
			if (result.length() > 0) result.append(", ");
			result.append("?");
		}
		return result.toString();
	}
	
	/**
	 * ǉJ擾
	 * @return ǉJ
	 */
	private String getColumnString() {
		StringBuffer result = new StringBuffer();
		Object[] key = super.getColumn().getMap().keySet().toArray();
		for (int i = 0; i < key.length; i++) {
			if (result.length() > 0) result.append(", ");
			result.append(key[i]);
		}
		return result.toString();
	}
	
	/**
	 * ǉl擾
	 * @return ǉl
	 */
	private String getValue() {
		StringBuffer result = new StringBuffer();
		Map map = super.getColumn().getMap();
		
		Object[] key = map.keySet().toArray();
		for (int i = 0; i < key.length; i++) {
			if (result.length() > 0) result.append(", ");
			if (map.get(key[i]) == null) {
			    result.append("NULL");
			}
			else if (map.get(key[i]) instanceof String) {
			    result.append("'");
			    result.append(map.get(key[i]));
			    result.append("'");
			}
			else {
				result.append(map.get(key[i]));
			}
		}
		return result.toString();
	}
}
