/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.exception.GeneratorException;


/**
 * {SQLNX.
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2006/04/08 08:48:16 $
 */
public abstract class BaseSql implements Sql {

	/**
	 * RXgN^
	 */
	public BaseSql() {
		super();
	}
	
	/**
	 * SQL擾
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	public String getSql() throws GeneratorException {
		return createSql(false);
	}
	
	/**
	 * ߍ݌^SQL擾
	 * @return ߍ݌^SQL
	 * @throws GeneratorException SQLO
	 */
	public String getBindSql() throws GeneratorException {
		return createSql(true);
	}
	
	/**
	 * SĂ̐ݒNA
	 */
	public abstract void clear();
	
	/**
	 * SQL쐬
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	protected abstract String createSql(boolean bind) throws GeneratorException;
}
