/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.sql.column.Column;
import org.sql.util.GeneratorUtils;

/**
 * ʓISQL𐶐ׂ̊{NX.
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2006/04/08 08:48:16 $
 */
public abstract class BaseSimpleSql extends BaseSql {

    /** J */
    private Column column = null;
    
	/** FROM */
	private String from = null;
	
	/**
	 * RXgN^
	 * @param table e[u
	 */
	public BaseSimpleSql(String table) {
		super();
	    this.from = table;
	}
	
	/**
	 * FROMݒ
	 * @param table e[u
	 */
	public void setFrom(String table) {
		this.from = table;
	}
	
	/**
	 * FROM擾
	 * @return FROM
	 */
	public String getFrom() {
		return this.from;
	}
	
	/**
	 * Jݒ
	 * @param column J
	 */
	public final void setColumn(Column column) {
	    this.column = column;
	}
	
	/**
	 * J擾
	 * @return J
	 */
	public final Column getColumn() {
		return this.column;
	}
	
	/**
	 * NA
	 */
	public void clear() {
	    this.column = null;
	    this.from = null;
	}
	
	/**
	 * oChp[^擾
	 * @return oChp[^
	 */
	public Object[] getParameter() {
		if (this.column == null) return null;
		return removeExclusion(this.column.getParameter());
	}
	
	/**
	 * Oie[uA\A֐ȂǁjoChlԂ
	 * @param objects oChp[^
	 * @return Oie[uA\A֐ȂǁjoChl
	 */
	protected Object[] removeExclusion(Object[] objects) {
		List result = new ArrayList();
		for (int i = 0; i < objects.length; i++) {
			if (objects[i] instanceof Object[]) {
				result.addAll(Arrays.asList(removeExclusion((Object[]) objects[i])));
			}
			else {
				if (GeneratorUtils.isExclusion(objects[i].toString())) continue;
				result.add(objects[i]);
			}
		}
		return result.toArray();
	}
}
