/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.condition;

import org.sql.comparison.Comparison;
import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.item.DefaultItems;
import org.sql.item.Item;
import org.sql.item.Items;


/**
 * Ǘׂ̊{NX.
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2006/04/08 08:48:16 $
 */
public abstract class BaseCondition implements Conditionable {

    /** WHERE */
    protected static final String WHERE = " WHERE ";
    /** AND */
    protected static final String AND = " AND ";
    /** OR */
    protected static final String OR = " OR ";
    
	/**  */
	private Items condition  = null;
	
	/** O */
	private Throwable exception = null;
	
	/**
	 * RXgN^
	 */
	public BaseCondition() {
		this.condition = new DefaultItems();
	}
	
	/**
	 * WHERE ` ANDݒ肷
	 * @param comparison rIuWFNg
	 */
	public void and(Comparison comparison) {
		createCondition(comparison, AND);
	}
	
	/**
	 * WHERE ` ORݒ肷
	 * @param comparison rIuWFNg
	 */
	public void or(Comparison comparison) {
		createCondition(comparison, OR);
	}
	
	/**
	 * 擾
	 * @return 
	 * @throws ComparisonException rO
	 */
	public String getCondition() throws ComparisonException {
	    if (this.exception != null) {
	        throw new ComparisonException(this.exception);
	    }
	    StringBuffer sb = new StringBuffer();
	    for (int i = 0; i < this.condition.size(); i++) {
	    	Item item = this.condition.get(i);
	    	Comparison comparison = (Comparison) item.getValue()[0];
	    	sb.append(item.getColumn());
	    	sb.append(comparison.toComparisonString());
	    }
	    return sb.toString();
	}
	
	/**
	 * NA
	 */
	public void clear() {
		this.condition = null;
		this.condition = new DefaultItems();
	}
	
	/**
	 * ݒ肳Ă邩mF
	 * @return ݒ[true]Aݒ[false]
	 */
	public boolean isEmpty() {
		return this.condition.isEmpty();
	}
	
	/**
	 * ݒ肷
	 * @param condition 
	 */
	protected void setCondition(String condition, Comparison comparison) {
		Item item = new DefaultItem();
		item.put(condition, comparison);
        this.condition.put(item);
	}
	
	/**
	 * Oݒ肷
	 * @param exception O
	 */
	protected void setException(Throwable exception) {
		this.exception = exception;
	}
	
	/**
	 * ݒ肷
	 * @param comparison rIuWFNg
	 * @param condition ANDAOR
	 */
	protected abstract void createCondition(Comparison comparison, String condition);
	
	/**
	 * ACe擾
	 * @return ACe
	 */
	protected final Items getConditionItems() {
		return this.condition;
	}
}
