/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.sql.comparison.BindComparison;
import org.sql.exception.ComparisonException;
import org.sql.item.Item;

/**
 * ߍ݌^̌Ǘׂ̊{NX.
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2006/04/08 08:48:16 $
 */
public abstract class BaseBindCondition extends BaseCondition {
	
	/** O */
	private Throwable exception = null;
	
	/**
	 * RXgN^
	 */
	public BaseBindCondition() {
		super();
	}
	
	/**
	 * ߍ݌^̌擾
	 * @return 
	 * @throws ComparisonException rO
	 */
	public String getBindCondition() throws ComparisonException {
	    if (this.exception != null) {
	        throw new ComparisonException(this.exception);
	    }
	    StringBuffer sb = new StringBuffer();
	    for (int i = 0; i < getConditionItems().size(); i++) {
	    	Item item = getConditionItems().get(i);
	    	if (item.getValue()[0] instanceof BindComparison) {
		    	BindComparison comparison = (BindComparison) item.getValue()[0];
		    	sb.append(item.getColumn());
		    	sb.append(comparison.toBindString());
	    	}
	    }
	    return sb.toString();
	}
	
	/**
	 * Oݒ肷
	 * @param exception O
	 */
	protected void setException(Throwable exception) {
		super.setException(exception);
		this.exception = exception;
	}
	
	/**
	 * oChp[^擾
	 * @return oChp[^
	 */
	public Object[] getParameter() {
		List list = new ArrayList();
	    for (int i = 0; i < getConditionItems().size(); i++) {
	    	Item item = getConditionItems().get(i);
	    	if (item.getValue()[0] instanceof BindComparison) {
		    	BindComparison comparison = (BindComparison) item.getValue()[0];
		    	list.addAll(Arrays.asList(comparison.getParameter()));
	    	}
	    }
	    return list.toArray();
	}
}
