/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.Date;

import org.sql.exception.ComparisonException;
import org.sql.exception.FormatException;
import org.sql.item.DefaultItem;
import org.sql.type.Format;
import org.sql.type.Match;
import org.sql.util.GeneratorUtils;


/**
 * ʓIȔrǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>Svݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>sSvݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 <> ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eqNot("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>ȏݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 >= ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.ge("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>ȉݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 <= ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.le("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>傫ݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 > ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.gt("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>ݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 < ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.lt("COLUMN1", ""));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.14 $ $Date: 2006/04/08 08:48:16 $
 */
public class SimpleComparison extends BaseBindComparison {

    /** r@ */
    private String property = null;
    /**  */
    private Format format = null;
    
	/**
	 * RXgN^iȂ̃CX^XȂj
	 */
	protected SimpleComparison() {}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 * @param match  r@
	 */
	public SimpleComparison(String column, Object value, Match match) {
	    setProperty(match.toTypeString());
	    setComparison(column, value);
	}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 * @param format IuWFNg
	 * @param match  r@
	 */
	public SimpleComparison(String column, Date value, Format format, Match match) {
	    setProperty(match.toTypeString());
	    setComparison(column, value, format);
	}
	
	/**
	 * rݒ肷
	 * @param column J
	 * @param value  l
	 */
	protected void setComparison(String column, Object value) {
		if (value instanceof Date) {
		    setComparison(column, (Date) value, Format.YMD_HMS);
		}
		else {
			DefaultItem item = new DefaultItem();
			item.put(column, value);
			super.setComparison(item);
		}
	}
	
	/**
	 * rݒ肷
	 * @param column J
	 * @param value  l
	 * @param format IuWFNg
	 */
	protected void setComparison(String column, Date value, Format format) {
		DefaultItem item = new DefaultItem();
		item.put(column, value);
        super.setComparison(item);
        this.format = format;
	}
	
	/**
	 * r@ݒ肷
	 * @param property r@
	 */
	protected final void setProperty(String property) {
	    this.property = property;
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append(item.getColumn());
		sb.append(this.property);
		Object object = item.getValue()[0];
		if (object instanceof Date) {
			sb.append(GeneratorUtils.toExclusionString(GeneratorUtils.formatExclusion(toDate((Date) object))));
		}
		else {
			sb.append(GeneratorUtils.toExclusionString(object));
		}
		return sb.toString();
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append(item.getColumn());
		sb.append(this.property);
		if (GeneratorUtils.isExclusion(item.getValue()[0].toString())) {
			sb.append(GeneratorUtils.toExclusionString(item.getValue()[0]));
		}
		else {
			sb.append("?");
		}
		return sb.toString();
	}
	
	/**
	 * TO_DATE̎擾
	 * @param date t
	 * @return TO_DATE
	 * @throws FormatException O
	 */
	private String toDate(Date date) {
		String result = null;
		try {
			result = super.toDate(date, this.format);
		}
		catch (FormatException e) {
			super.setException(e);
		}
		return result;
	}
}
