/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.type.Null;


/**
 * NULLǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>NULLݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 IS NULL</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.isNull("COLUMN1"));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>NOT NULLݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 IS NOT NULL</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.isNotNull("COLUMN1"));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.10 $ $Date: 2006/04/08 08:48:16 $
 */
public class NullComparison extends BaseComparison {

    /**
     * RXgN^
     * @param column J
     * @param nulltype NULL
     */
    public NullComparison(String column, Null nulltype) {
        setComparison(column, nulltype);
    }
    
    /**
     * rݒ肷
     * @param column J
     * @param nulltype NULL
     */
    protected void setComparison(String column, Null nulltype) {
    	DefaultItem item = new DefaultItem();
    	item.put(column, nulltype);
        super.setComparison(item);
    }
    
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append(item.getColumn());
		sb.append(" IS ");
		sb.append(((Null) item.getValue()[0]).toTypeString());
		return sb.toString();
	}
}
