/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.sql.exception.ComparisonException;
import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;
import org.sql.item.DefaultItem;


/**
 * EXISTSǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>EXISTSݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM EMP1 WHERE EXISTS (SELECT * FROM EMP2 WHERE HOGE = EMP1.HOGE)</font><br>
 *         <br>
 *    	     SelectSql sub = new SelectSql("EMP2");<br>
 *           Condition condition = new Condition();<br>
 *           condition.and(Comparisons.eq("HOGE", "{EMP1.HOGE}"));<br>
 *           sub.setCondition(condition);<br>
 *         <br>
 *           Condition condition2 = new Condition();<br>
 *           condition2.and(Comparisons.exists(sub));<br>
 *         <br>
 *           SelectSql sql = new SelectSql("EMP1");<br>
 *           sql.setCondition(condition2);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 * <ul>
 *     <li>NOT EXISTSݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM EMP1 WHERE NOT EXISTS (SELECT * FROM EMP2 WHERE HOGE = EMP1.HOGE)</font><br>
 *         <br>
 *           Condition condition = new Condition();<br>
 *           condition.and(Comparisons.eq("HOGE", "{EMP1.HOGE}"));<br>
 *         <br>
 *    	     SelectSql sub = new SelectSql("EMP2", condition);<br>
 *         <br>
 *           Condition condition2 = new Condition();<br>
 *           condition2.and(Comparisons.existsNot(sub));<br>
 *         <br>
 *           SelectSql sql = new SelectSql("EMP1", condition2);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.12 $ $Date: 2006/04/08 08:48:16 $
 */
public class ExistsComparison extends BaseBindComparison {

	/** NOT EXISTS[true]AEXISTS[false] */
	private boolean not = false;
	
	/**
	 * RXgN^
	 * @param sql SQLIuWFNg
	 */
    public ExistsComparison(Sql sql) {
        setComparison(sql, false);
    }
    
	/**
	 * RXgN^
	 * @param sql SQLIuWFNg
	 * @param not NOT EXISTS[true]AEXISTS[false]
	 */
    public ExistsComparison(Sql sql, boolean not) {
        setComparison(sql, true);
    }
	
	/**
	 * oChp[^擾
	 * @return oChp[^
	 */
	public Object[] getParameter() {
		List result = new ArrayList();
		Object[] parameter = super.getParameter();
		for (int i = 0; i < parameter.length; i++) {
			result.addAll(Arrays.asList(((Sql) parameter[i]).getParameter()));
		}
		return result.toArray();
	}
	
    /**
     * rݒ肷
	 * @param sql SQLIuWFNg
	 * @param not NOT EXISTS[true]AEXISTS[false]
     */
    protected void setComparison(Sql sql, boolean not) {
    	DefaultItem item = new DefaultItem();
    	item.put(null, sql);
        super.setComparison(item);
        this.not = not;
    }
    
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		return createComparison(item, false);
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		return createComparison(item, true);
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return r
	 * @throws ComparisonException rO
	 */
	private String createComparison(DefaultItem item, boolean bind) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		Sql sql = (Sql) item.getValue()[0];
        try {
            if (not) {
            	sb.append("NOT ");
            }
    		sb.append("EXISTS (");
   			sb.append(bind ? sql.getBindSql() : sql.getSql());
    		sb.append(")");
        }
        catch (GeneratorException e) {
            super.setException(e);
        }
		return sb.toString();
	}
}
