/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.column;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import org.sql.util.GeneratorUtils;


/**
 * XVJǗNX.
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.6 $ $Date: 2006/04/08 08:48:16 $
 */
public class RegistColumn extends BaseColumn {

	/** XV}bv */
	private Map valueMap = new LinkedHashMap();
	
    /**
     * RXgN^
     */
    public RegistColumn() {
        super();
    }
    
    /**
     * RXgN^
     * @param map XV}bv
     */
    public RegistColumn(Map map) {
        this();
        append(map);
    }
    
	/**
	 * XVǉ
	 * @param name J
	 * @param value l
	 */
	public void append(String name, Object value) {
		if (value == null) return;
		
		//ljava.util.DatȅꍇAjava.sql.Timestampɕϊ
		if (value instanceof Date) {
			valueMap.put(name, GeneratorUtils.parseStamp((Date) value));
		}
		else {
			valueMap.put(name, value);
		}
		
		super.append(name + " = " + GeneratorUtils.toExclusionString(value));
	}
	
	/**
	 * XVǉ
	 * @param map J}bv
	 */
	public void append(Map map) {
		Object[] object = map.keySet().toArray();
		for (int i = 0; i < object.length; i++) {
			append((String) object[i], map.get(object[i]));
		}
	}
	
	/**
	 * XV}bv擾
	 * @return XV}bv
	 */
	public Map getMap() {
	    return this.valueMap;
	}
}
