/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.column;

import java.util.LinkedHashMap;
import java.util.Map;

import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;


/**
 * JǗׂ̊{NX.
 *
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 * @version $Revision: 1.1 $ $Date: 2006/04/08 08:48:16 $
 */
public abstract class BaseSelectColumn extends BaseColumn {

	/** JƃGCAX̃}bv */
	private Map map = new LinkedHashMap();
	
    /**
     * RXgN^
     */
    public BaseSelectColumn() {
        super();
    }
    
	/**
	 * Jǉ
	 * @param columns Jz
	 */
	public void append(String[] columns) {
		for (int i = 0; i < columns.length; i++) {
		    append(columns[i]);
		}
	}
	
	/**
	 * Jǉ
	 * @param column J
	 */
	public void append(Object column) {
        append(column, null);
	}
	
	/**
	 * Jǉ
	 * @param column J
	 * @param as GCAX
	 */
	public void append(Object column, String as) {
	    map.put(column, as);
	}
	
	/**
	 * Jǉ
	 * @param columns Jz
	 * @param as GCAXz
	 */
	public void append(String[] columns, String[] as) {
		for (int i = 0; i < columns.length; i++) {
			append(columns[i], as[i]);
		}
	}
	
	/**
	 * J擾
	 * @return J
	 */
	public String toColumnString() {
		createColumn(false);
		return super.toColumnString();
	}
	
	/**
	 * ߍ݌^̃J擾
	 * @return ߍ݌^̃J
	 */
	public String toBindColumnString() {
		createColumn(true);
		return super.toColumnString();
	}

	/**
	 * J쐬
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @throws GeneratorException SQLO
	 */
	protected void createColumn(boolean bind) throws GeneratorException {
		StringBuffer buffer = new StringBuffer();
		super.clear();
		if (map.isEmpty()) {
		    super.append("*");
		    return;
		}
		Object[] key = map.keySet().toArray();
		for (int i = 0; i < key.length; i++) {
			Object column = key[i];
			if (column instanceof Sql) {
				Sql sql = (Sql) column;
				buffer.append("(");
				buffer.append((bind) ? sql.getBindSql() : sql.getSql());
				buffer.append(")");
			}
			else {
				buffer.append(column);
			}
			
			if (map.get(column) != null) {
				buffer.append(" AS ");
				buffer.append(map.get(column).toString());
			}
			super.append(buffer.toString());
			buffer.delete(0, buffer.toString().length());
		}
	}
}
