/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.update;

import org.sql.column.RegistColumn;
import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;
import org.sql.generator.UpdateSql;
import org.sql.sample.AbstractSample;
import org.sql.util.GeneratorUtils;


/**
 * XVSQL쐬NX
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 */
public class UpdateSample extends AbstractSample {

    /**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
     */
	protected Sql createSql() throws GeneratorException {
    	RegistColumn column = new RegistColumn();
        column.append("A", "");
        column.append("B", "");
        column.append("C", "");
        column.append("D", GeneratorUtils.formatExclusion("EMPTY_BLOB()"));
        
        Condition condition = new Condition();
        condition.and(Comparisons.eq("A", ""));
        
        return new UpdateSql("TABLE1", column, condition);
    }
}
