/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.union;

import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.generator.Sql;
import org.sql.generator.UnionSql;
import org.sql.sample.AbstractSample;
import org.sql.type.Order;


/**
 * UNION SQL쐬NX.
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 */
public class UnionSample1 extends AbstractSample {

	/**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
	 */
	protected Sql createSql() throws GeneratorException {
    	Condition condition = new Condition();
    	condition.and(Comparisons.eq("HOGE1", ""));

    	SelectSql sql1 = new SelectSql("EMP1", condition);
    	SelectSql sql2 = new SelectSql("EMP2", condition);

    	Order[] order = new Order[2];
    	order[0] = Order.asc("HOGE1");
    	order[1] = Order.desc("HOGE2");

    	UnionSql sql = new UnionSql();
    	sql.union(new SelectSql[]{sql1, sql2});
    	sql.addOrder(order);
    	
    	return sql;
    }
}
