/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.select;

import java.util.Arrays;

import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.generator.Sql;
import org.sql.sample.AbstractSample;


/**
 * Pe[uQƂSQL쐬NX
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 */
public class SelectSample5 extends AbstractSample {

	/**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
	 */
	protected Sql createSql() throws GeneratorException {
        //
        Condition condition = new Condition();
        condition.and(Comparisons.in("HOGE", Arrays.asList(new Object[] {"ق"})));
    	
        //SQL
        return new SelectSql("EMP1", condition);
    }
}
