/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.select;

import org.sql.column.SelectColumn;
import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.generator.Sql;
import org.sql.sample.AbstractSample;
import org.sql.type.Function;
import org.sql.type.LikeMatch;
import org.sql.type.Null;
import org.sql.util.GeneratorUtils;


/**
 * Pe[uQƂSQL쐬NX
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 */
public class SelectSample extends AbstractSample {

	/**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
	 */
	protected Sql createSql() throws GeneratorException {

        //Jݒ
        SelectColumn select = new SelectColumn();
        select.append(new Integer(0), "ID");
        select.append("HOGE_CD", "HOGE");
        select.append(Function.trim(GeneratorUtils.formatExclusion(Function.toChar("{HOGE_NUM}", "999,999,999").toTypeString())), "HOGE_NUM");
        select.append(Function.toChar("{HOGE_DATETIME}", "YY/MM/DD HH24:MM"), "HOGE_DATETIME");
        select.append(Function.toChar("{HOGE_DATE}", "MM/DD"), "HOGE_DATE");
        select.append(Null.NULL, "HOGE_NULL");

        //TuNG
        SelectColumn sub_column = new SelectColumn();
        sub_column.append("SUB_COLUMN");
        
        Condition condition1 = new Condition();
        condition1.and(Comparisons.eq("HOGEGE", ""));
        condition1.and(Comparisons.eq(Function.trim("{HOHOGE}").toTypeString(), GeneratorUtils.formatExclusion(Function.trim("{HOHOHO}").toTypeString())));

        SelectSql sub = new SelectSql("SUB_TABLE", sub_column, condition1);

        select.append(sub, "SUB");

        Condition condition2 = new Condition();
        condition2.and(Comparisons.between("HOGE2", new Integer(1), new Integer(100)));
        condition2.and(Comparisons.like("HOGE3", LikeMatch.anywhere("A")));
    	
        //SQL
        return new SelectSql("HOGE_TABLE", select, condition2);
    }
}
