/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.join;

import org.sql.column.JoinColumn;
import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.JoinSql;
import org.sql.generator.Sql;
import org.sql.sample.AbstractSample;
import org.sql.table.JoinTable;
import org.sql.table.JoinTableInfo;
import org.sql.type.Join;
import org.sql.type.Order;


/**
 * \SQL쐬NX
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 */
public class JoinSample2 extends AbstractSample {

	/**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
	 */
	protected Sql createSql() throws GeneratorException {
        //Jݒ
        JoinColumn join = new JoinColumn();
        join.append("TABLE1", "COLUMN1", "HOGE");
        join.append("TABLE2", "COLUMN2", "HOGEHOGE");
        
        //\
        JoinTableInfo info = new JoinTableInfo();
        info.setTable1("TABLE1");
        info.setColumn1("COLUMN1");
        info.setTable2("TABLE2");
        info.setColumn2("COLUMN1");
        info.setJoin(Join.OUTER);
        
        //
        Condition condition = new Condition();
        condition.and(Comparisons.eq("TABLE1.COLUMN1", new Integer(0)));
        
        //я
        Order[] order = new Order[2];
        order[0] = Order.asc("TABLE1.COLUMN1");
        order[1] = Order.asc("TABLE2.COLUMN2");
        
        //SQL
        JoinSql sql = new JoinSql();
        sql.addColumn(join);
        sql.addFrom(new JoinTable(info));
        sql.setCondition(condition);
        sql.addOrder(order);
        
        return sql;
    }
}
