/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample;

import org.sql.exception.GeneratorException;
import org.sql.generator.Sql;

/**
 * SQLoׂ͂̊{NX.
 * 
 * @author <a href="mailto:nagashiba.satoshi@opcybe.co.jp">Satoshi Nagashiba</a>
 */
public abstract class AbstractSample {

	/**
	 * SQLo͂
	 * 
	 * @throws GeneratorException SQLO
	 */
    public void println() throws GeneratorException {
    	Sql sql = createSql();
        System.out.println(sql.getSql());
        System.out.println(sql.getBindSql());
        Object[] params = sql.getParameter();
        if (params == null) {
        	params = new Object[] {""};
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; i++) {
        	if (sb.toString().length() > 0) {
        		sb.append(", ");
        	}
        	sb.append(params[i]);
        }
        System.out.println("[Parameter]F" + sb.toString() + "\n");
    }
    
    /**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
     */
    protected abstract Sql createSql() throws GeneratorException;
}
