/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.util;

import java.util.List;


/**
 * PɂĒu郆[eBeBNXłB
 * 
 * @author S.Nagashiba
 * @version $Revision: 1.2 $ $Date: 2006/02/05 16:12:38 $
 */
public final class ReplaceUtil {

	/**
	 * ΏەPŒu𐶐
	 * @param arg Ώە
	 * @param args P
	 * @return PŒu
	 */
	protected String createStrings(String arg, Object[] args) {
	    StringBuffer buffer = new StringBuffer(arg);
	    if (args != null) {
	        buffer.replace(0, arg.length(), replaceStrings(arg, args));
	    }
	    return buffer.toString();
	}
	
	/**
	 * ΏەPŒu
	 * @param arg Ώە
	 * @param args P
	 * @return PŒu
	 */
	protected String replaceStrings(String arg, Object[] args) {
	    String result = arg;
	    for (int i = 0; i < args.length; i++) {
	        String replace = replaceString(i);
	        result = result.replaceAll(replace, args[i].toString());
	    }
	    return result;
	}
	
	/**
	 * P̒u擾
	 * @param index CfbNX
	 * @return P̒u
	 */
	protected String replaceString(int index) {
	    return "\\{" + String.valueOf(index) + "\\}";
	}
	
	/**
	 * ΏەPŒu𐶐
	 * @param arg Ώە
	 * @param args P
	 * @return PŒu
	 */
	public static String replace(String arg, Object[] args) {
		return new ReplaceUtil().createStrings(arg, args);
	}
	
	/**
	 * ΏەPŒu𐶐
	 * @param arg1 Ώە
	 * @param arg2 P
	 * @return PŒu
	 */
	public static String replace(String arg1, String arg2) {
		return replace(arg1, new Object[] {arg2});
	}
	
	/**
	 * ΏەPŒu𐶐
	 * @param arg Ώە
	 * @param list PꃊXg
	 * @return PŒu
	 */
	public static String replace(String arg, List list) {
		return replace(arg, list.toArray());
	}
}
