/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * bNރNX.
 *
 * @author S.Nagashiba
 */
public class Lock implements Types {
	
    /** bN */
	private int lockMode;

	/** bN - ҂ */
	private static final int LOCK_WAIT = 0;
	/** bN - ҂Ȃ */
	private static final int LOCK_NOWAIT = 1;

	/** bN[h - ҂ */
	public static final Lock WAIT = new Lock(LOCK_WAIT);
	/** bN[h - ҂Ȃ */
	public static final Lock NOWAIT = new Lock(LOCK_NOWAIT);

	
	/**
	 * RXgN^
	 * @param lockMode bN[h
	 */
	protected Lock(int lockMode) {
		this.lockMode = lockMode;
	}
	
	/**
	 * bN擾
	 * @return bN
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.lockMode) {
			case LOCK_WAIT: ret = "FOR UPDATE"; break;
			case LOCK_NOWAIT: ret = "FOR UPDATE NOWAIT"; break;
		}
		return ret;
	}
}