/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.type;


/**
 * LikëvʂǗNX.
 *
 * @author S.Nagashiba
 */
public class LikeMatch implements Types {
    /** vR[h */
	private int matchCode;
	/** l */
	private String value = null;
	
	/** Sv */
	private static final int MATCH_EXACT = 0;
	/** Ov */
	private static final int MATCH_START = 1;
	/** v */
	private static final int MATCH_END = 2;
	/** Ov */
	private static final int MATCH_ANYWHERE = 3;
	
	/**
	 * RXgN^
	 * @param value     l
	 * @param matchCode vR[h
	 */
	protected LikeMatch(String value, int matchCode) {
	    this.value = value;
		this.matchCode = matchCode;
	}
	
	/**
	 * vp^[擾
	 * @return vp^[
	 */
	public String toTypeString() {
		String ret = null;
		switch (this.matchCode) {
			case MATCH_EXACT: ret = this.value; break;
			case MATCH_START: ret = this.value + '%'; break;
			case MATCH_END  : ret = '%' + this.value; break;
			case MATCH_ANYWHERE: ret = '%' + this.value + '%'; break;
		}
		return ret;
	}
	
	/**
	 * SvIuWFNg擾
	 * @param value l
	 */
	public static final LikeMatch exact(String value) {
	    return new LikeMatch(value, MATCH_EXACT);
	}
	
	/**
	 * OvIuWFNg擾
	 * @param value l
	 */
	public static final LikeMatch start(String value) {
	    return new LikeMatch(value, MATCH_START);
	}
	
	/**
	 * vIuWFNg擾
	 * @param value l
	 */
	public static final LikeMatch end(String value) {
	    return new LikeMatch(value, MATCH_END);
	}
	
	/**
	 * OvIuWFNg擾
	 * @param value l
	 */
	public static final LikeMatch anywhere(String value) {
	    return new LikeMatch(value, MATCH_ANYWHERE);
	}
}
