/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.column.SelectColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.type.Group;
import org.sql.type.Lock;
import org.sql.type.Order;
import org.sql.util.GeneratorUtil;


/**
 * Pe[uQSQL𐶐NX.
 * 
 * <P>
 * JAe[uAA\[gݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 = '' ORDER BY COLUMN1 ASC, COLUMN2 DESC</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         <br>
 *         @Order[] order = new Order[2];<br>
 *         @order[0] = Order.asc("COLUMN1");<br>
 *         @order[1] = Order.desc("COLUMN2");<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", condition);<br>
 *         @sql.addOrder(order);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class SelectSql extends AbstractConditionSql implements OrderBy, GroupBy {

	/** \[g */
    private StringBuffer order = new StringBuffer();
	/** bN */
    private String lockString = "";
	/** O[v */
	private Group group = null;
	/** DISTINCT */
	private boolean distinct = false;
	
	/**
	 * RXgN^
	 * @param table e[u
	 */
	public SelectSql(String table) {
		super(table);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column J
	 */
	public SelectSql(String table, SelectColumn column) {
		super(table);
		super.setColumn(column);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param condition 
	 */
	public SelectSql(String table, Condition condition) {
		super(table, condition);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column J
	 * @param condition 
	 */
	public SelectSql(String table, SelectColumn column, Condition condition) {
		super(table, condition);
		super.setColumn(column);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param distinct dsr[true]AdsrȂ[false]
	 */
	public SelectSql(String table, boolean distinct) {
		this(table);
		this.distinct = distinct;
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param column J
	 * @param distinct dsr[true]AdsrȂ[false]
	 */
	public SelectSql(String table, SelectColumn column, boolean distinct) {
		this(table, column);
		this.distinct = distinct;
	}
	
	/**
	 * \[gǉ
	 * @param order \[gIuWFNg
	 */
	public void addOrder(Order order) {
		if (this.order.length() > 0) {
			this.order.append(",");
		}
		this.order.append(order.toTypeString());
	}

	/**
	 * \[gǉ
	 * @param orders \[gIuWFNgz
	 */
	public void addOrder(Order[] orders) {
		for (int i = 0; i < orders.length; i++) {
		    addOrder(orders[i]);
		}
	}

	/** bN */
	public void lock(Lock lockmode) {
		this.lockString = " " + lockmode.toTypeString();
	}
	
	/**
	 * NA
	 */
	public void clear() {
		super.clear();
		this.order.delete(0, this.order.length());
		this.lockString = "";
	}
	
	/**
	 * O[vǉ
	 * @param group O[vIuWFNg
	 */
    public void addGroup(Group group) {
        this.group = group;
    }
	
	/**
	 * SQL쐬
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	protected String createSql(boolean bind) throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.getCondition() == null) {
			super.setCondition(new Condition());
		}
		if (!GeneratorUtil.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("SELECT ");
		if (this.distinct) {
		    result.append("DISTINCT ");
		}
		if (super.getColumn() == null) {
		    super.setColumn(new SelectColumn());
		}
		if (bind) {
			result.append(((SelectColumn) super.getColumn()).toBindColumnString());
		}
		else {
			result.append(super.getColumn().toColumnString());
		}
		result.append(" FROM " + getFrom());
		if (bind) {
			result.append(super.getCondition().getBindCondition());
		}
		else {
			result.append(super.getCondition().getCondition());
		}
		result.append(this.lockString);
		if (this.group != null) {
		    result.append(" GROUP BY " + this.group.toTypeString());
		}
		if (this.order.length() > 0) {
		    result.append(" ORDER BY " + this.order.toString());
		}
		return result.toString();
	}
}
