/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import java.util.Map;

import org.sql.column.JoinColumn;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.table.Table;
import org.sql.type.Group;
import org.sql.type.Order;


/**
 * \SQL𐶐NX.
 * 
 * <P>
 * JAe[uAݒ肵܂B<br>
 * <br>
 * J񂪕ێe[uFROM\zASQL𐶐܂B<br>
 * e[uGCAX́ÃNXɂĎ܂B<br>
 * <br>
 * <br>
 * <li>ʓIȕ\sꍇ</li>
 * <ul>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT A.COLUMN1 AS HOGE FROM TABLE1 A, TABLE2 B WHERE A.COLUMN1 = B.COLUMN2</font><br>
 *         <br>
 *         @JoinColumn column = new JoinColumn();<br>
 *         @column.append("TABLE1", "COLUMN1", "HOGE");<br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("TABLE1.COLUMN1", "{TABLE2.COLUMN2}"));<br>
 *         <br>
 *         @JoinSql sql = new JoinSql(column);<br>
 *         @sql.setCondition(condition);<br>
 * </td></tr></table>
 * </ul>
 * <br>
 * <li>OiOracle 8ȑOj̏ꍇ</li>
 * <ul>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT A.COLUMN1 AS HOGE FROM TABLE1 A, TABLE2 B WHERE A.COLUMN1 = B.COLUMN2(+)</font><br>
 *         <br>
 *         @JoinColumn column = new JoinColumn();<br>
 *         @column.append("TABLE1", "COLUMN1", "HOGE");<br>
 *         <br>
 *         @SimpleTable table = new SimpleTable(new String[]{"TABLE1", "TABLE2"});
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("TABLE1.COLUMN1", "{TABLE2.COLUMN2(+)}"));<br>
 *         <br>
 *         @JoinSql sql = new JoinSql(column, table);<br>
 *         @sql.setCondition(condition);<br>
 * </td></tr></table>
 * </ul>
 * <br>
 * <li>OiOracle 9ȍ~ASQL ServerAPostgreSQLAMySQLȂǁj̏ꍇ</li>
 * <ul>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT A.COLUMN1 AS HOGE FROM TABLE1 A OUTER JOIN TABLE2 B ON A.COLUMN1 = B.COLUMN2</font><br>
 *         <br>
 *         @JoinColumn column = new JoinColumn();<br>
 *         @column.append("TABLE1", "COLUMN1", "HOGE");<br>
 *         <br>
 *         @JoinTableInfo info = new JoinTableInfo();<br>
 *         @info.setTable1("TABLE1");<br>
 *         @info.setColumn1("COLUMN1");<br>
 *         @info.setTable2("TABLE2");<br>
 *         @info.setColumn2("COLUMN2");<br>
 *         @info.setJoin(Join.OUTER);<br>
 *         <br>
 *         @JoinSql sql = new JoinSql(column, new JoinTable(info));<br>
 * </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class JoinSql extends AbstractSql implements OrderBy, GroupBy {

	/** J */
	private JoinColumn column = null;
	/** \[g */
	private StringBuffer order = new StringBuffer();
	/** O[v */
	private Group group = null;
	/** \ */
	private Table table = null;
	/**  */
	private Condition condition = null;
	
	/**
	 * RXgN^
	 */
	public JoinSql() {}

	/**
	 * RXgN^
	 * @param column J
	 */
	public JoinSql(JoinColumn column) {
	    this();
	    addColumn(column);
	}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param table \
	 */
	public JoinSql(JoinColumn column, Table table) {
	    this(column);
	    addFrom(table);
	}

	/**
	 * Jǉ
	 * @param column J
	 */
	public void addColumn(JoinColumn column) {
	    this.column = column;
	}
	
	/**
	 * FROMݒ肷
	 * @param table \
	 */
	public void addFrom(Table table) {
	    this.table = table;
	}
	
	/**
	 * ǉ
	 * @param condition 
	 */
	public void setCondition(Condition condition) {
		this.condition = condition;
	}

	/**
	 * 擾
	 * @return 
	 */
	public Condition getCondition() {
		return this.condition;
	}
	
	/**
	 * oChp[^擾
	 * @return oChp[^
	 */
	public Object[] getParameter() {
	    return getCondition().getParameter();
	}
	
	/**
	 * \[gǉ
	 * @param order \[gIuWFNg
	 */
	public void addOrder(Order order) {
		if (this.order.length() == 0) {
			this.order.append(" ORDER BY ");
		}
		else {
			this.order.append(", ");
		}
		this.order.append(order.toTypeString());
	}

	/**
	 * \[gǉ
	 * @param orders \[gIuWFNgz
	 */
	public void addOrder(Order[] orders) {
		for (int i = 0; i < orders.length; i++) {
		    addOrder(orders[i]);
		}
	}
	
	/**
	 * O[vǉ
	 * @param group O[vIuWFNg
	 */
    public void addGroup(Group group) {
        this.group = group;
    }
    
	/**
	 * NA
	 */
	public void clear() {
		this.condition = null;
		this.column.clear();
		this.order.delete(0, this.order.toString().length());
		this.group = null;
		this.table = null;
	}
	
	/**
	 * SQL𐶐
	 * @param bind oChϐݒ肷邩
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	protected String createSql(boolean bind) throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (getCondition() == null) {
			setCondition(new Condition());
		}
		if (this.table == null) {
		    throw new GeneratorException(Message.getInstance("SQL-005"));
		}
		result.append("SELECT ");
		result.append(replaceColumn(this.column.toColumnString()));
	    result.append(" FROM ");
	    result.append(this.table.toTableString());
		if (bind) {
			result.append(replaceAlias(getCondition().getBindCondition()));
		}
		else {
			result.append(replaceAlias(getCondition().getCondition()));
		}

		if (this.group != null) {
		    result.append(" GROUP BY " + this.group.toTypeString());
		}
		result.append(createOrder());
		return result.toString();
	}
	
	/**
	 * Je[uGCAXɕύX
	 * @param column J
	 * @return ҏWꂽJ
	 */
	private String replaceColumn(String column) {
	    Map map = this.table.getTableMap();
	    Object[] table = map.keySet().toArray();
	    String result = column;
		for (int i = 0; i < table.length; i++) {
		    result = result.replaceAll((String) table[i], (String) map.get(table[i]));
		}
	    return result;
	}
	
	/**
	 * ORDER BY𐶐
	 * @return ORDER BY
	 */
	private String createOrder() {
	    return replaceAlias(this.order.toString());
	}
	
	/**
	 * GCAXɒu
	 * @param arg uΏە
	 * @return GCAXɒu
	 */
	private String replaceAlias(String arg) {
	    String result = arg;
	    if ((result == null) || (result.length() == 0)) {
	        return result;
	    }
	    Map map = this.table.getTableMap();
	    Object[] key = map.keySet().toArray();
	    for (int i = 0; i < key.length; i++) {
	        result = result.replaceAll((String) key[i], (String) map.get(key[i]));
	    }
	    return result;
	}
}
