/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.generator;

import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.message.Message;
import org.sql.util.GeneratorUtil;


/**
 * 폜SQLNX.
 * 
 * <P>
 * e[uAݒ肵܂B<br>
 * <br>
 * ݒ肳ꂽeIuWFNgSQL\z܂B<br>
 * <br>
 * <b>Java\[XTv</b><br>
 * <table><tr><td class="SampleCode">
 *         j<font color="blue">DELETE FROM TABLE1 WHERE COLUMN1 = ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.eq("COLUMN1", ""));<br>
 *         @<br>
 *         @DeleteSql sql = new DeleteSql("TABLE1", condition);<br>
 * </td></tr></table>
 * <P>
 *
 * @author S.Nagashiba
 */
public class DeleteSql extends AbstractConditionSql {

	/**
	 * RXgN^
	 * @param table e[u
	 */
	public DeleteSql(String table) {
		super(table);
	}
	
	/**
	 * RXgN^
	 * @param table e[u
	 * @param condition 
	 */
	public DeleteSql(String table, Condition condition) {
		super(table, condition);
	}

	/**
	 * SQL쐬
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return SQL
	 * @throws GeneratorException SQLO
	 */
	protected String createSql(boolean bind) throws GeneratorException {
		StringBuffer result = new StringBuffer();
		if (super.getCondition() == null) {
			super.setCondition(new Condition());
		}
		if (!GeneratorUtil.isNaming(getFrom())) {
		    throw new GeneratorException(Message.getInstance("SQL-001", getFrom()));
		}
		result.append("DELETE");
		result.append(" FROM " + getFrom());
		if (bind) {
			result.append(super.getCondition().getBindCondition());
		}
		else {
			result.append(super.getCondition().getCondition());
		}
		return result.toString();
	}
}
