/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.type.LikeMatch;
import org.sql.util.GeneratorUtil;

/**
 * LIKEǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>Svݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE ''</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.exact("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>Ovݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE '%'</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.start("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>vݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE '%'</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.end("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 *     <br>
 *     <br>
 *     <li>Ovݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 LIKE '%%'</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.like("COLUMN1", LikeMatch.anywhere("")));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class LikeComparison extends AbstractBindComparison {

	/**
	 * RXgN^
	 * @param column J
	 * @param match  vIuWFNg
	 */
	public LikeComparison(String column, LikeMatch match) {
		setComparison(column, match);
	}
	
	/**
	 * rݒ肷
	 * @param column J
	 * @param match  vIuWFNg
	 */
	public void setComparison(String column, LikeMatch match) {
		DefaultItem item = new DefaultItem();
		item.put(column, match.toTypeString());
		super.setComparison(item);
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		return createComparison(item, false);
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		return createComparison(item, true);
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return r
	 * @throws ComparisonException rO
	 */
	private String createComparison(DefaultItem item, boolean bind) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append(item.getColumn());
		sb.append(" like ");
		sb.append(bind ? "?" : GeneratorUtil.toQuoteString(item.getValue()[0]));
		return sb.toString();
	}
}
