/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.List;

import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.util.GeneratorUtil;

/**
 * INǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>INݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 IN (1, 2, 3)</font><br>
 *         <br>
 *         @List list = new ArrayList();<br>
 *         @list.add(new Integer(1));<br>
 *         @list.add(new Integer(2));<br>
 *         @list.add(new Integer(3));<br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.in("COLUMN1", list));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class InComparison extends AbstractBindComparison {
    
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 */
    public InComparison(String column, List value) {
	    this(column, value.toArray());
	}
	
	/**
	 * RXgN^
	 * @param column J
	 * @param value  l
	 */
	public InComparison(String column, Object[] value) {
	    setComparison(column, value);
	}
	
	/**
	 * rݒ肷
	 * @param column J
	 * @param value  l
	 */
	protected void setComparison(String column, Object[] value) {
		DefaultItem item = new DefaultItem();
		item.put(column, value);
		super.setComparison(item);
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		return createComparison(item, false);
	}
	
	/**
	 * oChr쐬
	 * @param item ACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		return createComparison(item, true);
	}
	
	/**
	 * r쐬
	 * @param item ACe
	 * @param bind ߍ݌^SQL[true]AʏSQL[false]
	 * @return r
	 * @throws ComparisonException rO
	 */
	private String createComparison(DefaultItem item, boolean bind) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append((" IN ("));
		for (int i = 0; i < item.size(); i++) {
			sb.append(bind ? "?" : GeneratorUtil.toQuoteString(item.getValue()[i]));

			if (i != (item.size() - 1)) {
				sb.append((","));
			}
		}
		sb.append((")"));
		return sb.toString();
	}
}
