/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import org.sql.exception.ComparisonException;
import org.sql.item.DefaultItem;
import org.sql.util.GeneratorUtil;


/**
 * BETWEENǗNX.
 * <P>
 * r̐́ArIuWFNgbp[NX
 * i<a href="Comparisons.html">com.sn.sql.comparison.Comparisons</a>jgp܂B<br>
 * <br>
 * <ul>
 *     <li>BETWEENݒ肷ꍇ<br>
 *     <br>
 *     <b>Java\[XTv</b><br>
 *     <table><tr><td class="SampleCode">
 *         j<font color="blue">SELECT * FROM TABLE1 WHERE COLUMN1 BETWEEN 0 AND 99</font><br>
 *         <br>
 *         @Condition condition = new Condition();<br>
 *         @condition.and(Comparisons.between("COLUMN1", new Integer(0), new Integer(99)));<br>
 *         <br>
 *         @SelectSql sql = new SelectSql("TABLE1", new SelectColumn(), condition);<br>
 *     </td></tr></table>
 * </ul>
 * <P>
 *
 * @author S.Nagashiba
 */
public class BetweenComparison extends AbstractBindComparison {

	/**
	 * r擾
	 * @param column J
	 * @param value1 l1
	 * @param value2 l2
	 */
    public BetweenComparison(String column, Object value1, Object value2) {
        setComparison(column, value1, value2);
    }
    
    /**
     * rݒ肷
	 * @param column J
	 * @param value1 l1
	 * @param value2 l2
     */
    protected void setComparison(String column, Object value1, Object value2) {
    	DefaultItem item = new DefaultItem();
    	item.put(column, new Object[] {value1, value2});
        super.setComparison(item);
    }
    
	/**
	 * r쐬
	 * @param item rACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append(item.getColumn());
		sb.append(" BETWEEN ");
		sb.append(GeneratorUtil.toQuoteString(item.getValue()[0]));
		sb.append(" AND ");
		sb.append(GeneratorUtil.toQuoteString(item.getValue()[1]));
		return sb.toString();
	}
	
	/**
	 * oChr쐬
	 * @param item rACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected String createBindComparison(DefaultItem item) throws ComparisonException {
		StringBuffer sb = new StringBuffer();
		sb.append(item.getColumn());
		sb.append(" BETWEEN ");
		sb.append("?");
		sb.append(" AND ");
		sb.append("?");
		return sb.toString();
	}
}
