/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.comparison;

import java.util.Date;

import org.sql.exception.ComparisonException;
import org.sql.exception.FormatException;
import org.sql.item.DefaultItem;
import org.sql.type.Format;
import org.sql.type.Function;
import org.sql.util.GeneratorUtil;


/**
 * rǗׂ̊{NX.
 * 
 * @author S.Nagashiba
 */
public abstract class AbstractComparison implements Comparison {
	
	/** r */
	private DefaultItem comparison  = new DefaultItem();
	
	/** O */
	private Throwable exception = null;

	/**
	 * RXgN^iȂ̃CX^XȂj
	 */
	protected AbstractComparison() {}
	
	/**
	 * r擾
	 * @return r
	 * @throws ComparisonException rO
	 */
	public String toComparisonString() throws ComparisonException {
		if (exception != null) {
			throw new ComparisonException(exception);
		}
		return createComparison(this.comparison);
	}
	
	/**
	 * NA
	 */
	public void clear() {
		this.comparison = null;
	}
	
	/**
	 * O擾
	 * @return O
	 */
	public Throwable getException() {
	    return this.exception;
	}
	
	/**
	 * rݒ肷
	 * @param comparison r
	 */
	protected void setComparison(DefaultItem comparison) {
		this.comparison = comparison;
	}
	
	/**
	 * TO_DATE̎擾
	 * @param value l
	 * @param format IuWFNg
	 * @return TO_DATE
	 * @throws FormatException O
	 */
	protected String toDate(Date value, Format format) throws FormatException {
		String todate = GeneratorUtil.dateToStr(value, format.getConvertFormat());
		return Function.toDate(todate, format.toTypeString()).toTypeString();
	}
	
	/**
	 * Oݒ肷
	 * @param exception O
	 */
	protected void setException(Throwable exception) {
		this.exception = exception;
	}
	
	/**
	 * r쐬
	 * @param item rACe
	 * @return r
	 * @throws ComparisonException rO
	 */
	protected abstract String createComparison(DefaultItem item) throws ComparisonException;
}
