/*
 * SQL Generator
 * 
 * Copyright (C) 2005 Satoshi Nagashiba, All Rights Reserved.
 */
package org.sql.sample.select;

import org.sql.comparison.Comparisons;
import org.sql.condition.Condition;
import org.sql.exception.GeneratorException;
import org.sql.generator.SelectSql;
import org.sql.generator.Sql;
import org.sql.sample.AbstractSample;


/**
 * Pe[uQƂSQL쐬NX
 * 
 * @author S.Nagashiba
 */
public class SelectSample3 extends AbstractSample {

	/**
     * SQL쐬
     * @return SQL
     * @throws GeneratorException SQLO
	 */
	protected Sql createSql() throws GeneratorException {

    	//TuNG
        Condition condition1 = new Condition();
        condition1.and(Comparisons.eq("HOGE", "{EMP1.HOGE}"));
    	SelectSql sub = new SelectSql("EMP2", condition1);
        
        //
        Condition condition2 = new Condition();
        condition2.and(Comparisons.existsNot(sub));
    	
        //SQL
        return new SelectSql("EMP1", condition2);
    }
}
